/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.okhttp;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.squareup.okhttp.ConnectionSpec;
import io.grpc.AbstractChannelBuilder;
import io.grpc.SharedResourceHolder;
import io.grpc.transport.ClientTransportFactory;
import io.grpc.transport.okhttp.OkHttpClientTransportFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLSocketFactory;

public final class OkHttpChannelBuilder
extends AbstractChannelBuilder<OkHttpChannelBuilder> {
    private static final SharedResourceHolder.Resource<ExecutorService> DEFAULT_TRANSPORT_THREAD_POOL = new SharedResourceHolder.Resource<ExecutorService>(){

        public ExecutorService create() {
            return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("grpc-okhttp-%d").build());
        }

        public void close(ExecutorService executor) {
            executor.shutdown();
        }
    };
    private final InetSocketAddress serverAddress;
    private ExecutorService transportExecutor;
    private String host;
    private SSLSocketFactory sslSocketFactory;
    private ConnectionSpec connectionSpec;

    public static OkHttpChannelBuilder forAddress(String host, int port) {
        return new OkHttpChannelBuilder(new InetSocketAddress(host, port), host);
    }

    private OkHttpChannelBuilder(InetSocketAddress serverAddress, String host) {
        this.serverAddress = (InetSocketAddress)Preconditions.checkNotNull((Object)serverAddress, (Object)"serverAddress");
        this.host = host;
    }

    public OkHttpChannelBuilder transportExecutor(ExecutorService executor) {
        this.transportExecutor = executor;
        return this;
    }

    public OkHttpChannelBuilder overrideHostForAuthority(String host) {
        this.host = host;
        return this;
    }

    public OkHttpChannelBuilder sslSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
        return this;
    }

    public OkHttpChannelBuilder setConnectionSpec(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
        return this;
    }

    protected AbstractChannelBuilder.ChannelEssentials buildEssentials() {
        final ExecutorService executor = this.transportExecutor == null ? (ExecutorService)SharedResourceHolder.get(DEFAULT_TRANSPORT_THREAD_POOL) : this.transportExecutor;
        OkHttpClientTransportFactory transportFactory = new OkHttpClientTransportFactory(this.serverAddress, this.host, executor, this.sslSocketFactory, this.connectionSpec);
        Runnable terminationRunnable = null;
        if (this.transportExecutor == null) {
            terminationRunnable = new Runnable(){

                @Override
                public void run() {
                    SharedResourceHolder.release((SharedResourceHolder.Resource)DEFAULT_TRANSPORT_THREAD_POOL, (Object)executor);
                }
            };
        }
        return new AbstractChannelBuilder.ChannelEssentials((ClientTransportFactory)transportFactory, terminationRunnable);
    }
}

