/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.TypeParameterMatcher;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.UnsupportedAddressTypeException;

public abstract class SimpleNameResolver<T extends SocketAddress>
implements NameResolver<T> {
    private final EventExecutor executor;
    private final TypeParameterMatcher matcher;

    protected SimpleNameResolver(EventExecutor executor) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.executor = executor;
        this.matcher = TypeParameterMatcher.find((Object)this, SimpleNameResolver.class, (String)"T");
    }

    protected SimpleNameResolver(EventExecutor executor, Class<? extends T> addressType) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.executor = executor;
        this.matcher = TypeParameterMatcher.get(addressType);
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    @Override
    public boolean isSupported(SocketAddress address) {
        return this.matcher.match((Object)address);
    }

    @Override
    public final boolean isResolved(SocketAddress address) {
        if (!this.isSupported(address)) {
            throw new UnsupportedAddressTypeException();
        }
        SocketAddress castAddress = address;
        return this.doIsResolved(castAddress);
    }

    protected abstract boolean doIsResolved(T var1);

    @Override
    public final Future<T> resolve(String inetHost, int inetPort) {
        if (inetHost == null) {
            throw new NullPointerException("inetHost");
        }
        return this.resolve(InetSocketAddress.createUnresolved(inetHost, inetPort));
    }

    @Override
    public Future<T> resolve(String inetHost, int inetPort, Promise<T> promise) {
        if (inetHost == null) {
            throw new NullPointerException("inetHost");
        }
        return this.resolve(InetSocketAddress.createUnresolved(inetHost, inetPort), promise);
    }

    @Override
    public final Future<T> resolve(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("unresolvedAddress");
        }
        if (!this.isSupported(address)) {
            return this.executor().newFailedFuture((Throwable)new UnsupportedAddressTypeException());
        }
        if (this.isResolved(address)) {
            SocketAddress cast = address;
            return this.executor.newSucceededFuture((Object)cast);
        }
        try {
            SocketAddress cast = address;
            Promise promise = this.executor().newPromise();
            this.doResolve(cast, promise);
            return promise;
        }
        catch (Exception e) {
            return this.executor().newFailedFuture((Throwable)e);
        }
    }

    @Override
    public final Future<T> resolve(SocketAddress address, Promise<T> promise) {
        if (address == null) {
            throw new NullPointerException("unresolvedAddress");
        }
        if (promise == null) {
            throw new NullPointerException("promise");
        }
        if (!this.isSupported(address)) {
            return promise.setFailure((Throwable)new UnsupportedAddressTypeException());
        }
        if (this.isResolved(address)) {
            SocketAddress cast = address;
            return promise.setSuccess((Object)cast);
        }
        try {
            SocketAddress cast = address;
            this.doResolve(cast, promise);
            return promise;
        }
        catch (Exception e) {
            return promise.setFailure((Throwable)e);
        }
    }

    protected abstract void doResolve(T var1, Promise<T> var2) throws Exception;

    @Override
    public void close() {
    }
}

