/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.netty;

import com.google.common.base.Preconditions;
import io.grpc.AbstractChannelBuilder;
import io.grpc.SharedResourceHolder;
import io.grpc.transport.ClientTransport;
import io.grpc.transport.ClientTransportFactory;
import io.grpc.transport.netty.GrpcSslContexts;
import io.grpc.transport.netty.NegotiationType;
import io.grpc.transport.netty.NettyClientTransport;
import io.grpc.transport.netty.ProtocolNegotiator;
import io.grpc.transport.netty.ProtocolNegotiators;
import io.grpc.transport.netty.Utils;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLException;

public final class NettyChannelBuilder
extends AbstractChannelBuilder<NettyChannelBuilder> {
    public static final int DEFAULT_CONNECTION_WINDOW_SIZE = 0x100000;
    public static final int DEFAULT_STREAM_WINDOW_SIZE = 65535;
    private final SocketAddress serverAddress;
    private NegotiationType negotiationType = NegotiationType.TLS;
    private Class<? extends Channel> channelType = NioSocketChannel.class;
    private EventLoopGroup userEventLoopGroup;
    private SslContext sslContext;
    private int connectionWindowSize = 0x100000;
    private int streamWindowSize = 65535;

    public static NettyChannelBuilder forAddress(SocketAddress serverAddress) {
        return new NettyChannelBuilder(serverAddress);
    }

    public static NettyChannelBuilder forAddress(String host, int port) {
        return NettyChannelBuilder.forAddress(new InetSocketAddress(host, port));
    }

    private NettyChannelBuilder(SocketAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    public NettyChannelBuilder channelType(Class<? extends Channel> channelType) {
        this.channelType = (Class)Preconditions.checkNotNull(channelType);
        return this;
    }

    public NettyChannelBuilder negotiationType(NegotiationType type) {
        this.negotiationType = type;
        return this;
    }

    public NettyChannelBuilder eventLoopGroup(EventLoopGroup group) {
        this.userEventLoopGroup = group;
        return this;
    }

    public NettyChannelBuilder sslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public NettyChannelBuilder connectionWindowSize(int connectionWindowSize) {
        Preconditions.checkArgument((connectionWindowSize > 0 ? 1 : 0) != 0, (Object)"connectionWindowSize must be positive");
        this.connectionWindowSize = connectionWindowSize;
        return this;
    }

    public NettyChannelBuilder streamWindowSize(int streamWindowSize) {
        Preconditions.checkArgument((streamWindowSize > 0 ? 1 : 0) != 0, (Object)"streamWindowSize must be positive");
        this.streamWindowSize = streamWindowSize;
        return this;
    }

    protected AbstractChannelBuilder.ChannelEssentials buildEssentials() {
        ProtocolNegotiator negotiator;
        final EventLoopGroup group = this.userEventLoopGroup == null ? (EventLoopGroup)SharedResourceHolder.get(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP) : this.userEventLoopGroup;
        NegotiationType negotiationType = this.negotiationType;
        final Class<? extends Channel> channelType = this.channelType;
        final int connectionWindowSize = this.connectionWindowSize;
        final int streamWindowSize = this.streamWindowSize;
        switch (negotiationType) {
            case PLAINTEXT: {
                negotiator = ProtocolNegotiators.plaintext();
                break;
            }
            case PLAINTEXT_UPGRADE: {
                negotiator = ProtocolNegotiators.plaintextUpgrade();
                break;
            }
            case TLS: {
                if (!(this.serverAddress instanceof InetSocketAddress)) {
                    throw new IllegalStateException("TLS not supported for non-internet socket types");
                }
                if (this.sslContext == null) {
                    try {
                        this.sslContext = GrpcSslContexts.forClient().build();
                    }
                    catch (SSLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                negotiator = ProtocolNegotiators.tls(this.sslContext, (InetSocketAddress)this.serverAddress);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported negotiationType: " + (Object)((Object)negotiationType));
            }
        }
        ClientTransportFactory transportFactory = new ClientTransportFactory(){

            public ClientTransport newClientTransport() {
                return new NettyClientTransport(NettyChannelBuilder.this.serverAddress, channelType, group, negotiator, connectionWindowSize, streamWindowSize);
            }
        };
        Runnable terminationRunnable = null;
        if (this.userEventLoopGroup == null) {
            terminationRunnable = new Runnable(){

                @Override
                public void run() {
                    SharedResourceHolder.release(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP, (Object)group);
                }
            };
        }
        return new AbstractChannelBuilder.ChannelEssentials(transportFactory, terminationRunnable);
    }
}

