/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.netty;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.transport.ServerStream;
import io.grpc.transport.ServerStreamListener;
import io.grpc.transport.ServerTransportListener;
import io.grpc.transport.TransportFrameUtil;
import io.grpc.transport.netty.NettyServerStream;
import io.grpc.transport.netty.RequestMessagesCommand;
import io.grpc.transport.netty.SendGrpcFrameCommand;
import io.grpc.transport.netty.SendResponseHeadersCommand;
import io.grpc.transport.netty.Utils;
import io.grpc.transport.netty.WriteQueue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.util.ByteString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class NettyServerHandler
extends Http2ConnectionHandler {
    private static Logger logger = Logger.getLogger(NettyServerHandler.class.getName());
    private static final Status GOAWAY_STATUS = Status.UNAVAILABLE;
    private final Http2Connection.PropertyKey streamKey;
    private final ServerTransportListener transportListener;
    private Throwable connectionError;
    private ChannelHandlerContext ctx;
    private boolean teWarningLogged;
    private int connectionWindowSize;
    private WriteQueue serverWriteQueue;

    NettyServerHandler(ServerTransportListener transportListener, Http2Connection connection, Http2FrameReader frameReader, Http2FrameWriter frameWriter, int maxStreams, int connectionWindowSize, int streamWindowSize) {
        super(connection, frameReader, frameWriter, (Http2FrameListener)new LazyFrameListener());
        Preconditions.checkArgument((connectionWindowSize > 0 ? 1 : 0) != 0, (Object)"connectionWindowSize must be positive");
        this.connectionWindowSize = connectionWindowSize;
        try {
            this.decoder().flowController().initialWindowSize(streamWindowSize);
        }
        catch (Http2Exception e) {
            throw new RuntimeException(e);
        }
        this.streamKey = connection.newKey();
        this.transportListener = (ServerTransportListener)Preconditions.checkNotNull((Object)transportListener, (Object)"transportListener");
        this.initListener();
        connection.local().allowPushTo(false);
        connection.remote().maxActiveStreams(maxStreams);
    }

    @Nullable
    Throwable connectionError() {
        return this.connectionError;
    }

    private void initListener() {
        ((LazyFrameListener)this.decoder().listener()).setHandler(this);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.serverWriteQueue = new WriteQueue(ctx.channel());
        super.handlerAdded(ctx);
        this.initConnectionWindow();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.initConnectionWindow();
    }

    private void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers) throws Http2Exception {
        if (!this.teWarningLogged && !Utils.TE_TRAILERS.equals(headers.get((Object)Utils.TE_HEADER))) {
            logger.warning(String.format("Expected header TE: %s, but %s is received. This means some intermediate proxy may not support trailers", Utils.TE_TRAILERS, headers.get((Object)Utils.TE_HEADER)));
            this.teWarningLogged = true;
        }
        try {
            Http2Stream http2Stream = this.requireHttp2Stream(streamId);
            NettyServerStream stream = new NettyServerStream(ctx.channel(), http2Stream, this);
            http2Stream.setProperty(this.streamKey, (Object)stream);
            String method = this.determineMethod(streamId, headers);
            ServerStreamListener listener = this.transportListener.streamCreated((ServerStream)stream, method, Utils.convertHeaders(headers));
            stream.setListener(listener);
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onHeadersRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    private void onDataRead(int streamId, ByteBuf data, boolean endOfStream) throws Http2Exception {
        try {
            NettyServerStream stream = this.serverStream(this.requireHttp2Stream(streamId));
            stream.inboundDataReceived(data, endOfStream);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onDataRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    private void onRstStreamRead(int streamId) throws Http2Exception {
        try {
            NettyServerStream stream = this.serverStream(this.requireHttp2Stream(streamId));
            stream.abortStream(Status.CANCELLED, false);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onRstStreamRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    protected void onConnectionError(ChannelHandlerContext ctx, Throwable cause, Http2Exception http2Ex) {
        logger.log(Level.WARNING, "Connection Error", cause);
        this.connectionError = cause;
        super.onConnectionError(ctx, cause, http2Ex);
    }

    protected void onStreamError(ChannelHandlerContext ctx, Throwable cause, Http2Exception.StreamException http2Ex) {
        logger.log(Level.WARNING, "Stream Error", cause);
        Http2Stream stream = this.connection().stream(Http2Exception.streamId((Http2Exception)http2Ex));
        if (stream != null) {
            this.serverStream(stream).abortStream(Status.fromThrowable((Throwable)cause), true);
        } else {
            super.onStreamError(ctx, cause, http2Ex);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.connection().forEachActiveStream(new Http2StreamVisitor(){

            public boolean visit(Http2Stream stream) throws Http2Exception {
                NettyServerHandler.this.serverStream(stream).abortStream(GOAWAY_STATUS, false);
                return true;
            }
        });
    }

    WriteQueue getWriteQueue() {
        return this.serverWriteQueue;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Http2Exception {
        if (msg instanceof SendGrpcFrameCommand) {
            this.sendGrpcFrame(ctx, (SendGrpcFrameCommand)((Object)msg), promise);
        } else if (msg instanceof SendResponseHeadersCommand) {
            this.sendResponseHeaders(ctx, (SendResponseHeadersCommand)msg, promise);
        } else if (msg instanceof RequestMessagesCommand) {
            ((RequestMessagesCommand)msg).requestMessages();
        } else {
            AssertionError e = new AssertionError((Object)("Write called for unexpected type: " + msg.getClass().getName()));
            ReferenceCountUtil.release((Object)msg);
            promise.setFailure((Throwable)((Object)e));
            throw e;
        }
    }

    void returnProcessedBytes(Http2Stream http2Stream, int bytes) {
        try {
            this.decoder().flowController().consumeBytes(this.ctx, http2Stream, bytes);
        }
        catch (Http2Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void closeStreamWhenDone(ChannelPromise promise, int streamId) throws Http2Exception {
        final NettyServerStream stream = this.serverStream(this.requireHttp2Stream(streamId));
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                stream.complete();
            }
        });
    }

    private void sendGrpcFrame(ChannelHandlerContext ctx, SendGrpcFrameCommand cmd, ChannelPromise promise) throws Http2Exception {
        if (cmd.endStream()) {
            this.closeStreamWhenDone(promise, cmd.streamId());
        }
        this.encoder().writeData(ctx, cmd.streamId(), cmd.content(), 0, cmd.endStream(), promise);
    }

    private void sendResponseHeaders(ChannelHandlerContext ctx, SendResponseHeadersCommand cmd, ChannelPromise promise) throws Http2Exception {
        if (cmd.endOfStream()) {
            this.closeStreamWhenDone(promise, cmd.streamId());
        }
        this.encoder().writeHeaders(ctx, cmd.streamId(), cmd.headers(), 0, cmd.endOfStream(), promise);
    }

    private Http2Stream requireHttp2Stream(int streamId) {
        Http2Stream stream = this.connection().stream(streamId);
        if (stream == null) {
            throw new AssertionError((Object)("Stream does not exist: " + streamId));
        }
        return stream;
    }

    private String determineMethod(int streamId, Http2Headers headers) throws Http2Exception {
        if (!Utils.HTTP_METHOD.equals((Object)headers.method())) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.REFUSED_STREAM, (String)"Method '%s' is not supported", (Object[])new Object[]{headers.method()});
        }
        NettyServerHandler.checkHeader(streamId, headers, Utils.CONTENT_TYPE_HEADER, Utils.CONTENT_TYPE_GRPC);
        String methodName = TransportFrameUtil.getFullMethodNameFromPath((String)headers.path().toString());
        if (methodName == null) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.REFUSED_STREAM, (String)"Malformatted path: %s", (Object[])new Object[]{headers.path()});
        }
        return methodName;
    }

    private static void checkHeader(int streamId, Http2Headers headers, ByteString header, ByteString expectedValue) throws Http2Exception {
        if (!expectedValue.equals(headers.get((Object)header))) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.REFUSED_STREAM, (String)"Header '%s'='%s', while '%s' is expected", (Object[])new Object[]{header, headers.get((Object)header), expectedValue});
        }
    }

    private NettyServerStream serverStream(Http2Stream stream) {
        return (NettyServerStream)((Object)stream.getProperty(this.streamKey));
    }

    private Http2Exception newStreamException(int streamId, Throwable cause) {
        return Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.INTERNAL_ERROR, (String)cause.getMessage(), (Object[])new Object[]{cause});
    }

    private void initConnectionWindow() throws Http2Exception {
        if (this.connectionWindowSize > 0 && this.ctx.channel().isActive()) {
            Http2Stream connectionStream = this.connection().connectionStream();
            int currentSize = ((Http2LocalFlowController)this.connection().local().flowController()).windowSize(connectionStream);
            int delta = this.connectionWindowSize - currentSize;
            this.decoder().flowController().incrementWindowSize(this.ctx, connectionStream, delta);
            this.connectionWindowSize = -1;
        }
    }

    private static class LazyFrameListener
    extends Http2FrameAdapter {
        private NettyServerHandler handler;

        private LazyFrameListener() {
        }

        void setHandler(NettyServerHandler handler) {
            this.handler = handler;
        }

        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            this.handler.onDataRead(streamId, data, endOfStream);
            return padding;
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
            this.handler.onHeadersRead(ctx, streamId, headers);
        }

        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
            this.handler.onRstStreamRead(streamId);
        }
    }
}

