/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.netty;

import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.transport.AbstractServerStream;
import io.grpc.transport.AbstractStream;
import io.grpc.transport.ReadableBuffer;
import io.grpc.transport.WritableBuffer;
import io.grpc.transport.WritableBufferAllocator;
import io.grpc.transport.netty.NettyReadableBuffer;
import io.grpc.transport.netty.NettyServerHandler;
import io.grpc.transport.netty.NettyWritableBuffer;
import io.grpc.transport.netty.NettyWritableBufferAllocator;
import io.grpc.transport.netty.RequestMessagesCommand;
import io.grpc.transport.netty.SendGrpcFrameCommand;
import io.grpc.transport.netty.SendResponseHeadersCommand;
import io.grpc.transport.netty.Utils;
import io.grpc.transport.netty.WriteQueue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.GenericFutureListener;

class NettyServerStream
extends AbstractServerStream<Integer> {
    private final Channel channel;
    private final NettyServerHandler handler;
    private final Http2Stream http2Stream;
    private WriteQueue writeQueue;

    NettyServerStream(Channel channel, Http2Stream http2Stream, NettyServerHandler handler) {
        super((WritableBufferAllocator)new NettyWritableBufferAllocator(channel.alloc()));
        this.writeQueue = handler.getWriteQueue();
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.http2Stream = (Http2Stream)Preconditions.checkNotNull((Object)http2Stream, (Object)"http2Stream");
        this.handler = (NettyServerHandler)((Object)Preconditions.checkNotNull((Object)((Object)handler), (Object)"handler"));
    }

    public Integer id() {
        return this.http2Stream.id();
    }

    void inboundDataReceived(ByteBuf frame, boolean endOfStream) {
        super.inboundDataReceived((ReadableBuffer)new NettyReadableBuffer(frame.retain()), endOfStream);
    }

    public void request(int numMessages) {
        if (this.channel.eventLoop().inEventLoop()) {
            this.requestMessagesFromDeframer(numMessages);
        } else {
            this.writeQueue.enqueue(new RequestMessagesCommand((AbstractStream<Integer>)this, numMessages), true);
        }
    }

    protected void inboundDeliveryPaused() {
    }

    protected void internalSendHeaders(Metadata.Headers headers) {
        this.writeQueue.enqueue(new SendResponseHeadersCommand(this.id(), Utils.convertServerHeaders(headers), false), true);
    }

    protected void sendFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        ByteBuf bytebuf = ((NettyWritableBuffer)frame).bytebuf();
        final int numBytes = bytebuf.readableBytes();
        this.onSendingBytes(numBytes);
        this.writeQueue.enqueue((Object)new SendGrpcFrameCommand((AbstractStream<Integer>)this, bytebuf, endOfStream), this.channel.newPromise().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                NettyServerStream.this.onSentBytes(numBytes);
            }
        }), flush);
    }

    protected void sendTrailers(Metadata.Trailers trailers, boolean headersSent) {
        Http2Headers http2Trailers = Utils.convertTrailers(trailers, headersSent);
        this.writeQueue.enqueue(new SendResponseHeadersCommand(this.id(), http2Trailers, true), true);
    }

    protected void returnProcessedBytes(int processedBytes) {
        this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
        this.writeQueue.scheduleFlush();
    }
}

