/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.netty;

import com.google.common.base.Preconditions;
import io.grpc.transport.ServerTransport;
import io.grpc.transport.ServerTransportListener;
import io.grpc.transport.netty.NettyServerHandler;
import io.grpc.transport.netty.ProtocolNegotiators;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;

class NettyServerTransport
implements ServerTransport {
    private static final Logger log = Logger.getLogger(NettyServerTransport.class.getName());
    private final Channel channel;
    private final SslContext sslContext;
    private final int maxStreams;
    private ServerTransportListener listener;
    private boolean terminated;
    private int connectionWindowSize;
    private int streamWindowSize;

    NettyServerTransport(Channel channel, @Nullable SslContext sslContext, int maxStreams, int connectionWindowSize, int streamWindowSize) {
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.sslContext = sslContext;
        this.maxStreams = maxStreams;
        this.connectionWindowSize = connectionWindowSize;
        this.streamWindowSize = streamWindowSize;
    }

    public void start(ServerTransportListener listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Handler already registered");
        this.listener = listener;
        final NettyServerHandler handler = this.createHandler(listener);
        this.channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                NettyServerTransport.this.notifyTerminated(handler.connectionError());
            }
        });
        if (this.sslContext != null) {
            SSLEngine sslEngine = this.sslContext.newEngine(this.channel.alloc());
            this.channel.pipeline().addLast(new ChannelHandler[]{ProtocolNegotiators.serverTls(sslEngine)});
        }
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
    }

    public void shutdown() {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
    }

    private void notifyTerminated(Throwable t) {
        if (t != null) {
            log.log(Level.SEVERE, "Transport failed", t);
        }
        if (!this.terminated) {
            this.terminated = true;
            this.listener.transportTerminated();
        }
    }

    private NettyServerHandler createHandler(ServerTransportListener transportListener) {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        Http2FrameLogger frameLogger = new Http2FrameLogger(LogLevel.DEBUG, this.getClass());
        Http2InboundFrameLogger frameReader = new Http2InboundFrameLogger((Http2FrameReader)new DefaultHttp2FrameReader(), frameLogger);
        Http2OutboundFrameLogger frameWriter = new Http2OutboundFrameLogger((Http2FrameWriter)new DefaultHttp2FrameWriter(), frameLogger);
        return new NettyServerHandler(transportListener, (Http2Connection)connection, (Http2FrameReader)frameReader, (Http2FrameWriter)frameWriter, this.maxStreams, this.connectionWindowSize, this.streamWindowSize);
    }
}

