/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import io.grpc.AbstractChannelBuilder;
import io.grpc.HandlerRegistry;
import io.grpc.MutableHandlerRegistry;
import io.grpc.MutableHandlerRegistryImpl;
import io.grpc.ServerImpl;
import io.grpc.ServerServiceDefinition;
import io.grpc.SharedResourceHolder;
import io.grpc.transport.Server;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public abstract class AbstractServerBuilder<BuilderT extends AbstractServerBuilder<BuilderT>> {
    private final HandlerRegistry registry;
    @Nullable
    private ExecutorService userExecutor;

    protected AbstractServerBuilder(HandlerRegistry registry) {
        this.registry = (HandlerRegistry)Preconditions.checkNotNull((Object)registry);
    }

    protected AbstractServerBuilder() {
        this.registry = new MutableHandlerRegistryImpl();
    }

    public final BuilderT executor(ExecutorService executor) {
        this.userExecutor = executor;
        return (BuilderT)this;
    }

    public final BuilderT addService(ServerServiceDefinition service) {
        if (this.registry instanceof MutableHandlerRegistry) {
            ((MutableHandlerRegistry)this.registry).addService(service);
            return (BuilderT)this;
        }
        throw new UnsupportedOperationException("Underlying HandlerRegistry is not mutable");
    }

    public ServerImpl build() {
        boolean releaseExecutor;
        ExecutorService executor;
        if (this.userExecutor != null) {
            executor = this.userExecutor;
            releaseExecutor = false;
        } else {
            executor = SharedResourceHolder.get(AbstractChannelBuilder.DEFAULT_EXECUTOR);
            releaseExecutor = true;
        }
        final ServerEssentials essentials = this.buildEssentials();
        ServerImpl server = new ServerImpl(executor, this.registry, essentials.server);
        server.setTerminationRunnable(new Runnable(){

            @Override
            public void run() {
                if (releaseExecutor) {
                    SharedResourceHolder.release(AbstractChannelBuilder.DEFAULT_EXECUTOR, executor);
                }
                if (essentials.terminationRunnable != null) {
                    essentials.terminationRunnable.run();
                }
            }
        });
        return server;
    }

    protected abstract ServerEssentials buildEssentials();

    protected static class ServerEssentials {
        final Server server;
        @Nullable
        final Runnable terminationRunnable;

        public ServerEssentials(Server server, @Nullable Runnable terminationRunnable) {
            this.server = (Server)Preconditions.checkNotNull((Object)server, (Object)"server");
            this.terminationRunnable = terminationRunnable;
        }
    }
}

