/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import io.grpc.ChannelImpl;
import io.grpc.testing.TestUtils;
import io.grpc.testing.integration.AbstractTransportTest;
import io.grpc.transport.netty.GrpcSslContexts;
import io.grpc.transport.netty.NegotiationType;
import io.grpc.transport.netty.NettyChannelBuilder;
import io.grpc.transport.okhttp.OkHttpChannelBuilder;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;

public class TestServiceClient {
    private String serverHost = "localhost";
    private String serverHostOverride;
    private int serverPort = 8080;
    private String testCase = "empty_unary";
    private boolean useTls = true;
    private boolean useTestCa;
    private boolean useOkHttp;
    private Tester tester = new Tester();

    public static void main(String[] args) throws Exception {
        final TestServiceClient client = new TestServiceClient();
        client.parseArgs(args);
        client.setUp();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Shutting down");
                try {
                    client.tearDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            client.run();
        }
        finally {
            client.tearDown();
        }
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("server_host".equals(key)) {
                this.serverHost = value;
                continue;
            }
            if ("server_host_override".equals(key)) {
                this.serverHostOverride = value;
                continue;
            }
            if ("server_port".equals(key)) {
                this.serverPort = Integer.parseInt(value);
                continue;
            }
            if ("test_case".equals(key)) {
                this.testCase = value;
                continue;
            }
            if ("use_tls".equals(key)) {
                this.useTls = Boolean.parseBoolean(value);
                continue;
            }
            if ("use_test_ca".equals(key)) {
                this.useTestCa = Boolean.parseBoolean(value);
                continue;
            }
            if ("use_okhttp".equals(key)) {
                this.useOkHttp = Boolean.parseBoolean(value);
                continue;
            }
            if ("grpc_version".equals(key)) {
                if ("2".equals(value)) continue;
                System.err.println("Only grpc version 2 is supported");
                usage = true;
                break;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (usage) {
            TestServiceClient c = new TestServiceClient();
            System.out.println("Usage: [ARGS...]\n\n  --server_host=HOST          Server to connect to. Default " + c.serverHost + "\n  --server_host_override=HOST Claimed identification expected of server." + "\n                              Defaults to server host" + "\n  --server_port=PORT          Port to connect to. Default " + c.serverPort + "\n  --test_case=TESTCASE        Test case to run. Default " + c.testCase + "\n  --use_tls=true|false        Whether to use TLS. Default " + c.useTls + "\n  --use_test_ca=true|false    Whether to trust our fake CA. Default " + c.useTestCa + "\n  --use_okhttp=true|false     Whether to use OkHttp instead of Netty. Default " + c.useOkHttp);
            System.exit(1);
        }
    }

    private void setUp() {
        this.tester.setUp();
    }

    private synchronized void tearDown() {
        try {
            this.tester.tearDown();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void run() {
        System.out.println("Running test " + this.testCase);
        try {
            this.runTest(this.testCase);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        System.out.println("Test completed.");
    }

    private void runTest(String testCase) throws Exception {
        if ("empty_unary".equals(testCase)) {
            this.tester.emptyUnary();
        } else if ("large_unary".equals(testCase)) {
            this.tester.largeUnary();
        } else if ("client_streaming".equals(testCase)) {
            this.tester.clientStreaming();
        } else if ("server_streaming".equals(testCase)) {
            this.tester.serverStreaming();
        } else if ("ping_pong".equals(testCase)) {
            this.tester.pingPong();
        } else if ("empty_stream".equals(testCase)) {
            this.tester.emptyStream();
        } else if ("cancel_after_begin".equals(testCase)) {
            this.tester.cancelAfterBegin();
        } else if ("cancel_after_first_response".equals(testCase)) {
            this.tester.cancelAfterFirstResponse();
        } else {
            throw new IllegalArgumentException("Unknown test case: " + testCase);
        }
    }

    private class Tester
    extends AbstractTransportTest {
        private Tester() {
        }

        @Override
        protected ChannelImpl createChannel() {
            if (!TestServiceClient.this.useOkHttp) {
                InetAddress address;
                try {
                    address = InetAddress.getByName(TestServiceClient.this.serverHost);
                    if (TestServiceClient.this.serverHostOverride != null) {
                        address = InetAddress.getByAddress(TestServiceClient.this.serverHostOverride, address.getAddress());
                    }
                }
                catch (UnknownHostException ex) {
                    throw new RuntimeException(ex);
                }
                SslContext sslContext = null;
                if (TestServiceClient.this.useTestCa) {
                    try {
                        sslContext = GrpcSslContexts.forClient().trustManager(TestUtils.loadCert((String)"ca.pem")).build();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return NettyChannelBuilder.forAddress((SocketAddress)new InetSocketAddress(address, TestServiceClient.this.serverPort)).negotiationType(TestServiceClient.this.useTls ? NegotiationType.TLS : NegotiationType.PLAINTEXT).sslContext(sslContext).build();
            }
            OkHttpChannelBuilder builder = OkHttpChannelBuilder.forAddress((String)TestServiceClient.this.serverHost, (int)TestServiceClient.this.serverPort);
            if (TestServiceClient.this.serverHostOverride != null) {
                builder.overrideHostForAuthority(TestServiceClient.this.serverHostOverride);
            }
            if (TestServiceClient.this.useTls) {
                try {
                    SSLSocketFactory factory = TestServiceClient.this.useTestCa ? TestUtils.getSslSocketFactoryForCertainCert((File)TestUtils.loadCert((String)"ca.pem")) : (SSLSocketFactory)SSLSocketFactory.getDefault();
                    builder.sslSocketFactory(factory);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return builder.build();
        }
    }
}

