/*
 * Decompiled with CFR 0.152.
 */
package io.github.devatherock.json.formatter;

import io.github.devatherock.json.formatter.helpers.Constants;
import io.github.devatherock.json.formatter.helpers.CustomJsonConverter;
import io.github.devatherock.json.formatter.helpers.GsonJsonConverter;
import io.github.devatherock.json.formatter.helpers.JacksonJsonConverter;
import io.github.devatherock.json.formatter.helpers.JsonConverter;
import io.github.devatherock.json.formatter.helpers.SimpleJsonConverter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Instant;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JSONFormatter
extends Formatter {
    private static final JsonConverter CONVERTER = JSONFormatter.createJsonConverter();
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final Map<Integer, String> THREAD_NAME_CACHE = new LinkedHashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, String> eldest) {
            return this.size() > 10000;
        }
    };
    private final boolean useSlf4jLevelNames;
    private final String timestampKey;
    private final String loggerNameKey;
    private final String logLevelKey;
    private final String threadNameKey;
    private final String loggerClassKey;
    private final String loggerMethodKey;
    private final String messageKey;
    private final String exceptionKey;

    public JSONFormatter() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        String value = manager.getProperty(cname + ".use_slf4j_level_names");
        this.useSlf4jLevelNames = Boolean.valueOf(value);
        value = manager.getProperty(cname + ".key_timestamp");
        this.timestampKey = value != null ? value : "@timestamp";
        value = manager.getProperty(cname + ".key_logger_name");
        this.loggerNameKey = value != null ? value : "logger_name";
        value = manager.getProperty(cname + ".key_log_level");
        this.logLevelKey = value != null ? value : "level";
        value = manager.getProperty(cname + ".key_thread_name");
        this.threadNameKey = value != null ? value : "thread_name";
        value = manager.getProperty(cname + ".key_logger_class");
        this.loggerClassKey = value != null ? value : "class";
        value = manager.getProperty(cname + ".key_logger_method");
        this.loggerMethodKey = value != null ? value : "method";
        value = manager.getProperty(cname + ".key_message");
        this.messageKey = value != null ? value : "message";
        value = manager.getProperty(cname + ".key_exception");
        this.exceptionKey = value != null ? value : "exception";
    }

    @Override
    public String format(LogRecord record) {
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        object.put(this.timestampKey, Constants.ISO_8601_FORMAT.format(Instant.ofEpochMilli(record.getMillis())));
        object.put(this.loggerNameKey, record.getLoggerName());
        if (this.useSlf4jLevelNames) {
            object.put(this.logLevelKey, this.renameLogLevel(record.getLevel().getName()));
        } else {
            object.put(this.logLevelKey, record.getLevel().getName());
        }
        object.put(this.threadNameKey, JSONFormatter.getThreadName(record.getThreadID()));
        if (null != record.getSourceClassName()) {
            object.put(this.loggerClassKey, record.getSourceClassName());
        }
        if (null != record.getSourceMethodName()) {
            object.put(this.loggerMethodKey, record.getSourceMethodName());
        }
        object.put(this.messageKey, this.formatMessage(record));
        if (null != record.getThrown()) {
            EnumMap<Constants.ExceptionKeys, String> exceptionInfo = new EnumMap<Constants.ExceptionKeys, String>(Constants.ExceptionKeys.class);
            exceptionInfo.put(Constants.ExceptionKeys.exception_class, record.getThrown().getClass().getName());
            if (record.getThrown().getMessage() != null) {
                exceptionInfo.put(Constants.ExceptionKeys.exception_message, record.getThrown().getMessage());
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            exceptionInfo.put(Constants.ExceptionKeys.stack_trace, sw.toString());
            object.put(this.exceptionKey, exceptionInfo);
        }
        return CONVERTER.convertToJson(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getThreadName(int logRecordThreadId) {
        String result = THREAD_NAME_CACHE.get(logRecordThreadId);
        if (result != null) {
            return result;
        }
        if (logRecordThreadId > 0x3FFFFFFF) {
            result = String.valueOf(logRecordThreadId);
        } else {
            ThreadInfo threadInfo = THREAD_MX_BEAN.getThreadInfo(logRecordThreadId);
            if (threadInfo == null) {
                return String.valueOf(logRecordThreadId);
            }
            result = threadInfo.getThreadName();
        }
        Map<Integer, String> map = THREAD_NAME_CACHE;
        synchronized (map) {
            THREAD_NAME_CACHE.put(logRecordThreadId, result);
        }
        return result;
    }

    private static JsonConverter createJsonConverter() {
        JsonConverter jsonConverter = null;
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            jsonConverter = new JacksonJsonConverter();
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.google.gson.Gson");
                jsonConverter = new GsonJsonConverter();
            }
            catch (ClassNotFoundException e1) {
                try {
                    Class.forName("org.json.simple.JSONObject");
                    jsonConverter = new SimpleJsonConverter();
                }
                catch (ClassNotFoundException e2) {
                    Logger.getAnonymousLogger().log(Level.WARNING, "None of GSON/Jackson/json-simple found in classpath");
                    jsonConverter = new CustomJsonConverter();
                }
            }
        }
        return jsonConverter;
    }

    private String renameLogLevel(String logLevel) {
        switch (logLevel) {
            case "FINEST": {
                return "TRACE";
            }
            case "FINER": 
            case "FINE": {
                return "DEBUG";
            }
            case "INFO": 
            case "CONFIG": {
                return "INFO";
            }
            case "WARNING": {
                return "WARN";
            }
            case "SEVERE": {
                return "ERROR";
            }
        }
        return logLevel;
    }
}

