/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IgnoreJRERequirement;
import com.google.common.truth.Subject;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

@IgnoreJRERequirement
public final class OptionalSubject
extends Subject {
    private final @Nullable Optional<?> actual;

    OptionalSubject(FailureMetadata failureMetadata, @Nullable Optional<?> subject, @Nullable String typeDescription) {
        super(failureMetadata, subject, typeDescription);
        this.actual = subject;
    }

    public void isPresent() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected present optional"), new Fact[0]);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact("expected to be present"), new Fact[0]);
        }
    }

    public void isEmpty() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected empty optional"), new Fact[0]);
        } else if (this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact("expected to be empty"), Fact.fact("but was present with value", this.actual.get()));
        }
    }

    public void hasValue(@Nullable Object expected) {
        if (expected == null) {
            throw new NullPointerException("Optional cannot have a null value.");
        }
        if (this.actual == null) {
            this.failWithActual("expected an optional with value", expected);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.fact("expected to have value", expected), Fact.simpleFact("but was empty"));
        } else {
            this.checkNoNeedToDisplayBothValues("get()", new Object[0]).that(this.actual.get()).isEqualTo(expected);
        }
    }

    @Deprecated
    public static Subject.Factory<OptionalSubject, Optional<?>> optionals() {
        return (metadata, subject) -> new OptionalSubject(metadata, (Optional<?>)subject, "optional");
    }
}

