/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.internal.LogExceptionRunnable;
import io.grpc.services.CallMetricRecorder;
import io.grpc.services.MetricRecorder;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.EmptyProtos;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import io.grpc.testing.integration.Util;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class TestServiceImpl
implements BindableService,
TestServiceGrpc.AsyncService {
    private final Random random = new Random();
    private final ScheduledExecutorService executor;
    private final ByteString compressableBuffer;
    private final MetricRecorder metricRecorder;
    final Semaphore lock = new Semaphore(1);

    public TestServiceImpl(ScheduledExecutorService executor, MetricRecorder metricRecorder) {
        this.executor = executor;
        this.compressableBuffer = ByteString.copyFrom((byte[])new byte[1024]);
        this.metricRecorder = metricRecorder;
    }

    public TestServiceImpl(ScheduledExecutorService executor) {
        this(executor, MetricRecorder.newInstance());
    }

    public final ServerServiceDefinition bindService() {
        return TestServiceGrpc.bindService(this);
    }

    @Override
    public void emptyCall(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
        responseObserver.onNext((Object)EmptyProtos.Empty.getDefaultInstance());
        responseObserver.onCompleted();
    }

    @Override
    public void unaryCall(Messages.SimpleRequest req, StreamObserver<Messages.SimpleResponse> responseObserver) {
        ServerCallStreamObserver obs = (ServerCallStreamObserver)responseObserver;
        Messages.SimpleResponse.Builder responseBuilder = Messages.SimpleResponse.newBuilder();
        try {
            if (req.hasResponseCompressed() && req.getResponseCompressed().getValue()) {
                obs.setCompression("gzip");
            } else {
                obs.setCompression("identity");
            }
        }
        catch (IllegalArgumentException e) {
            obs.onError((Throwable)Status.UNIMPLEMENTED.withDescription("compression not supported.").withCause((Throwable)e).asRuntimeException());
            return;
        }
        if (req.getResponseSize() != 0) {
            int offset = this.random.nextInt(this.compressableBuffer.size());
            ByteString payload = this.generatePayload(this.compressableBuffer, offset, req.getResponseSize());
            responseBuilder.setPayload(Messages.Payload.newBuilder().setBody(payload));
        }
        if (req.hasResponseStatus()) {
            obs.onError((Throwable)Status.fromCodeValue((int)req.getResponseStatus().getCode()).withDescription(req.getResponseStatus().getMessage()).asRuntimeException());
            return;
        }
        if (req.hasOrcaPerQueryReport()) {
            TestServiceImpl.echoCallMetricsFromPayload(req.getOrcaPerQueryReport());
        }
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    private static void echoCallMetricsFromPayload(Messages.TestOrcaReport report) {
        CallMetricRecorder recorder = CallMetricRecorder.getCurrent().recordCpuUtilizationMetric(report.getCpuUtilization()).recordMemoryUtilizationMetric(report.getMemoryUtilization());
        for (Map.Entry<String, Double> entry : report.getUtilizationMap().entrySet()) {
            recorder.recordUtilizationMetric(entry.getKey(), entry.getValue().doubleValue());
        }
        for (Map.Entry<String, Double> entry : report.getRequestCostMap().entrySet()) {
            recorder.recordRequestCostMetric(entry.getKey(), entry.getValue().doubleValue());
        }
    }

    private void echoMetricsFromPayload(Messages.TestOrcaReport report) {
        this.metricRecorder.setCpuUtilizationMetric(report.getCpuUtilization());
        this.metricRecorder.setMemoryUtilizationMetric(report.getMemoryUtilization());
        this.metricRecorder.setAllUtilizationMetrics(new HashMap());
        for (Map.Entry<String, Double> entry : report.getUtilizationMap().entrySet()) {
            this.metricRecorder.putUtilizationMetric(entry.getKey(), entry.getValue().doubleValue());
        }
    }

    @Override
    public void streamingOutputCall(Messages.StreamingOutputCallRequest request, StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
        new ResponseDispatcher(responseObserver).enqueue(this.toChunkQueue(request)).completeInput();
    }

    @Override
    public StreamObserver<Messages.StreamingInputCallRequest> streamingInputCall(final StreamObserver<Messages.StreamingInputCallResponse> responseObserver) {
        return new StreamObserver<Messages.StreamingInputCallRequest>(){
            private int totalPayloadSize;

            public void onNext(Messages.StreamingInputCallRequest message) {
                this.totalPayloadSize += message.getPayload().getBody().size();
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Messages.StreamingInputCallResponse.newBuilder().setAggregatedPayloadSize(this.totalPayloadSize).build());
                responseObserver.onCompleted();
            }

            public void onError(Throwable cause) {
                responseObserver.onError(cause);
            }
        };
    }

    @Override
    public StreamObserver<Messages.StreamingOutputCallRequest> fullDuplexCall(final StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
        final ResponseDispatcher dispatcher = new ResponseDispatcher(responseObserver);
        return new StreamObserver<Messages.StreamingOutputCallRequest>(){
            boolean oobTestLocked;

            public void onNext(Messages.StreamingOutputCallRequest request) {
                if (request.hasOrcaOobReport()) {
                    if (!this.oobTestLocked) {
                        try {
                            TestServiceImpl.this.lock.acquire();
                        }
                        catch (InterruptedException ex) {
                            responseObserver.onError((Throwable)new StatusRuntimeException(Status.ABORTED.withDescription("server service interrupted").withCause((Throwable)ex)));
                            return;
                        }
                        this.oobTestLocked = true;
                    }
                    TestServiceImpl.this.echoMetricsFromPayload(request.getOrcaOobReport());
                }
                if (request.hasResponseStatus()) {
                    dispatcher.cancel();
                    dispatcher.onError(Status.fromCodeValue((int)request.getResponseStatus().getCode()).withDescription(request.getResponseStatus().getMessage()).asRuntimeException());
                    return;
                }
                dispatcher.enqueue(TestServiceImpl.this.toChunkQueue(request));
            }

            public void onCompleted() {
                if (this.oobTestLocked) {
                    TestServiceImpl.this.lock.release();
                    this.oobTestLocked = false;
                }
                if (!dispatcher.isCancelled()) {
                    dispatcher.completeInput();
                }
            }

            public void onError(Throwable cause) {
                if (this.oobTestLocked) {
                    TestServiceImpl.this.lock.release();
                    this.oobTestLocked = false;
                }
                dispatcher.onError(cause);
            }
        };
    }

    @Override
    public StreamObserver<Messages.StreamingOutputCallRequest> halfDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
        final ResponseDispatcher dispatcher = new ResponseDispatcher(responseObserver);
        final ArrayDeque chunks = new ArrayDeque();
        return new StreamObserver<Messages.StreamingOutputCallRequest>(){

            public void onNext(Messages.StreamingOutputCallRequest request) {
                chunks.addAll(TestServiceImpl.this.toChunkQueue(request));
            }

            public void onCompleted() {
                dispatcher.enqueue(chunks).completeInput();
            }

            public void onError(Throwable cause) {
                dispatcher.onError(cause);
            }
        };
    }

    public Queue<Chunk> toChunkQueue(Messages.StreamingOutputCallRequest request) {
        ArrayDeque<Chunk> chunkQueue = new ArrayDeque<Chunk>();
        int offset = 0;
        for (Messages.ResponseParameters params : request.getResponseParametersList()) {
            chunkQueue.add(new Chunk(params.getIntervalUs(), offset, params.getSize()));
            offset = (offset + params.getSize()) % this.compressableBuffer.size();
        }
        return chunkQueue;
    }

    private ByteString generatePayload(ByteString dataBuffer, int offset, int size) {
        ByteString payload = ByteString.EMPTY;
        int begin = offset;
        int end = 0;
        for (int bytesLeft = size; bytesLeft > 0; bytesLeft -= end - begin) {
            end = Math.min(begin + bytesLeft, dataBuffer.size());
            payload = payload.concat(dataBuffer.substring(begin, end));
            begin = end % dataBuffer.size();
        }
        return payload;
    }

    public static List<ServerInterceptor> interceptors() {
        return Arrays.asList(TestServiceImpl.echoRequestHeadersInterceptor(Util.METADATA_KEY), TestServiceImpl.echoRequestMetadataInHeaders(Util.ECHO_INITIAL_METADATA_KEY), TestServiceImpl.echoRequestMetadataInTrailers(Util.ECHO_TRAILING_METADATA_KEY));
    }

    private static ServerInterceptor echoRequestHeadersInterceptor(Metadata.Key<?> ... keys) {
        final HashSet keySet = new HashSet(Arrays.asList(keys));
        return new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, final Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                    public void sendHeaders(Metadata responseHeaders) {
                        responseHeaders.merge(requestHeaders, keySet);
                        super.sendHeaders(responseHeaders);
                    }

                    public void close(Status status, Metadata trailers) {
                        trailers.merge(requestHeaders, keySet);
                        super.close(status, trailers);
                    }
                }, requestHeaders);
            }
        };
    }

    private static ServerInterceptor echoRequestMetadataInHeaders(Metadata.Key<?> ... keys) {
        final HashSet keySet = new HashSet(Arrays.asList(keys));
        return new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, final Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                    public void sendHeaders(Metadata responseHeaders) {
                        responseHeaders.merge(requestHeaders, keySet);
                        super.sendHeaders(responseHeaders);
                    }

                    public void close(Status status, Metadata trailers) {
                        super.close(status, trailers);
                    }
                }, requestHeaders);
            }
        };
    }

    private static ServerInterceptor echoRequestMetadataInTrailers(Metadata.Key<?> ... keys) {
        final HashSet keySet = new HashSet(Arrays.asList(keys));
        return new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, final Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                    public void sendHeaders(Metadata responseHeaders) {
                        super.sendHeaders(responseHeaders);
                    }

                    public void close(Status status, Metadata trailers) {
                        trailers.merge(requestHeaders, keySet);
                        super.close(status, trailers);
                    }
                }, requestHeaders);
            }
        };
    }

    private class Chunk {
        private final int delayMicroseconds;
        private final int offset;
        private final int length;

        public Chunk(int delayMicroseconds, int offset, int length) {
            this.delayMicroseconds = delayMicroseconds;
            this.offset = offset;
            this.length = length;
        }

        private Messages.StreamingOutputCallResponse toResponse() {
            Messages.StreamingOutputCallResponse.Builder responseBuilder = Messages.StreamingOutputCallResponse.newBuilder();
            ByteString payload = TestServiceImpl.this.generatePayload(TestServiceImpl.this.compressableBuffer, this.offset, this.length);
            responseBuilder.setPayload(Messages.Payload.newBuilder().setBody(payload));
            return responseBuilder.build();
        }
    }

    private class ResponseDispatcher {
        private final Chunk completionChunk;
        private final Queue<Chunk> chunks;
        private final StreamObserver<Messages.StreamingOutputCallResponse> responseStream;
        private boolean scheduled;
        @GuardedBy(value="this")
        private boolean cancelled;
        private Throwable failure;
        private Runnable dispatchTask;

        public ResponseDispatcher(StreamObserver<Messages.StreamingOutputCallResponse> responseStream) {
            this.completionChunk = new Chunk(0, 0, 0);
            this.dispatchTask = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            ResponseDispatcher.this.dispatchChunk();
                        }
                        catch (RuntimeException e) {
                            ResponseDispatcher responseDispatcher = ResponseDispatcher.this;
                            synchronized (responseDispatcher) {
                                ResponseDispatcher.this.scheduled = false;
                            }
                            throw e;
                        }
                        ResponseDispatcher e = ResponseDispatcher.this;
                        synchronized (e) {
                            ResponseDispatcher.this.scheduled = false;
                            ResponseDispatcher.this.scheduleNextChunk();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            };
            this.chunks = Queues.newLinkedBlockingQueue();
            this.responseStream = responseStream;
        }

        public synchronized ResponseDispatcher enqueue(Queue<Chunk> moreChunks) {
            this.assertNotFailed();
            this.chunks.addAll(moreChunks);
            this.scheduleNextChunk();
            return this;
        }

        public ResponseDispatcher completeInput() {
            this.assertNotFailed();
            this.chunks.add(this.completionChunk);
            this.scheduleNextChunk();
            return this;
        }

        public synchronized void cancel() {
            Preconditions.checkState((!this.cancelled ? 1 : 0) != 0, (Object)"Dispatcher already cancelled");
            this.chunks.clear();
            this.cancelled = true;
        }

        public synchronized boolean isCancelled() {
            return this.cancelled;
        }

        private synchronized void onError(Throwable cause) {
            this.responseStream.onError(cause);
        }

        private synchronized void dispatchChunk() {
            if (this.cancelled) {
                return;
            }
            try {
                Chunk chunk = this.chunks.remove();
                if (chunk == this.completionChunk) {
                    this.responseStream.onCompleted();
                } else {
                    this.responseStream.onNext((Object)chunk.toResponse());
                }
            }
            catch (Throwable e) {
                this.failure = e;
                if (Status.fromThrowable((Throwable)e).getCode() == Status.CANCELLED.getCode()) {
                    this.chunks.clear();
                }
                this.responseStream.onError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleNextChunk() {
            ResponseDispatcher responseDispatcher = this;
            synchronized (responseDispatcher) {
                if (this.scheduled) {
                    return;
                }
                Chunk nextChunk = this.chunks.peek();
                if (nextChunk != null && !TestServiceImpl.this.executor.isShutdown()) {
                    this.scheduled = true;
                    ScheduledFuture<?> scheduledFuture = TestServiceImpl.this.executor.schedule((Runnable)new LogExceptionRunnable(this.dispatchTask), (long)nextChunk.delayMicroseconds, TimeUnit.MICROSECONDS);
                }
            }
        }

        private void assertNotFailed() {
            if (this.failure != null) {
                throw new IllegalStateException("Stream already failed", this.failure);
            }
        }
    }
}

