/*
 * Copyright 2016 Game Server Services, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package io.gs2.quest.model;

import java.util.ArrayList;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * クリア報酬
 *
 * @author Game Server Services, Inc.
 *
 */
@SuppressWarnings("serial")
@JsonIgnoreProperties(ignoreUnknown=true)
public class Reward implements Serializable {
	/** スタンプシートで実行するアクションの種類 */
	protected String action;

	/**
	 * スタンプシートで実行するアクションの種類を取得
	 *
	 * @return スタンプシートで実行するアクションの種類
	 */
	public String getAction() {
		return action;
	}

	/**
	 * スタンプシートで実行するアクションの種類を設定
	 *
	 * @param action スタンプシートで実行するアクションの種類
	 */
	public void setAction(String action) {
		this.action = action;
	}

	/**
	 * スタンプシートで実行するアクションの種類を設定
	 *
	 * @param action スタンプシートで実行するアクションの種類
	 * @return this
	 */
	public Reward withAction(String action) {
		this.action = action;
		return this;
	}
	/** リクエストモデル */
	protected String request;

	/**
	 * リクエストモデルを取得
	 *
	 * @return リクエストモデル
	 */
	public String getRequest() {
		return request;
	}

	/**
	 * リクエストモデルを設定
	 *
	 * @param request リクエストモデル
	 */
	public void setRequest(String request) {
		this.request = request;
	}

	/**
	 * リクエストモデルを設定
	 *
	 * @param request リクエストモデル
	 * @return this
	 */
	public Reward withRequest(String request) {
		this.request = request;
		return this;
	}
	/** 入手するリソースGRN */
	protected String itemId;

	/**
	 * 入手するリソースGRNを取得
	 *
	 * @return 入手するリソースGRN
	 */
	public String getItemId() {
		return itemId;
	}

	/**
	 * 入手するリソースGRNを設定
	 *
	 * @param itemId 入手するリソースGRN
	 */
	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	/**
	 * 入手するリソースGRNを設定
	 *
	 * @param itemId 入手するリソースGRN
	 * @return this
	 */
	public Reward withItemId(String itemId) {
		this.itemId = itemId;
		return this;
	}
	/** 入手する数量 */
	protected Integer value;

	/**
	 * 入手する数量を取得
	 *
	 * @return 入手する数量
	 */
	public Integer getValue() {
		return value;
	}

	/**
	 * 入手する数量を設定
	 *
	 * @param value 入手する数量
	 */
	public void setValue(Integer value) {
		this.value = value;
	}

	/**
	 * 入手する数量を設定
	 *
	 * @param value 入手する数量
	 * @return this
	 */
	public Reward withValue(Integer value) {
		this.value = value;
		return this;
	}

    public ObjectNode toJson() {
		ObjectNode body_ = JsonNodeFactory.instance.objectNode()
            .put("action", this.getAction())
            .put("request", this.getRequest())
            .put("itemId", this.getItemId())
            .put("value", this.getValue());
        return body_;
    }
}