/*
 * Copyright 2016 Game Server Services, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package io.gs2.ranking.control;

import org.json.JSONObject;
import java.util.List;
import io.gs2.ranking.Gs2Ranking;
import io.gs2.control.Gs2BasicRequest;

/**
 * @author Game Server Services, Inc.
 */
@SuppressWarnings("serial")
public class GetRankingRequest extends Gs2BasicRequest<GetRankingRequest> {

	public static class Constant extends Gs2Ranking.Constant {
		public static final String FUNCTION = "GetRanking";
	}

	/** ランキングテーブルの名前を指定します。 */
	private String rankingTableName;

	/** ゲームモードの名前を指定します。 */
	private String gameMode;

	/** ランキングの取得位置を指定します */
	private Integer offset;

	/** ランキングの取得件数を指定します */
	private Integer limit;


	/**
	 * ランキングテーブルの名前を指定します。を取得
	 *
	 * @return ランキングテーブルの名前を指定します。
	 */
	public String getRankingTableName() {
		return rankingTableName;
	}

	/**
	 * ランキングテーブルの名前を指定します。を設定
	 *
	 * @param rankingTableName ランキングテーブルの名前を指定します。
	 */
	public void setRankingTableName(String rankingTableName) {
		this.rankingTableName = rankingTableName;
	}

	/**
	 * ランキングテーブルの名前を指定します。を設定
	 *
	 * @param rankingTableName ランキングテーブルの名前を指定します。
	 * @return this
	 */
	public GetRankingRequest withRankingTableName(String rankingTableName) {
		setRankingTableName(rankingTableName);
		return this;
	}

	/**
	 * ゲームモードの名前を指定します。を取得
	 *
	 * @return ゲームモードの名前を指定します。
	 */
	public String getGameMode() {
		return gameMode;
	}

	/**
	 * ゲームモードの名前を指定します。を設定
	 *
	 * @param gameMode ゲームモードの名前を指定します。
	 */
	public void setGameMode(String gameMode) {
		this.gameMode = gameMode;
	}

	/**
	 * ゲームモードの名前を指定します。を設定
	 *
	 * @param gameMode ゲームモードの名前を指定します。
	 * @return this
	 */
	public GetRankingRequest withGameMode(String gameMode) {
		setGameMode(gameMode);
		return this;
	}

	/**
	 * ランキングの取得位置を指定しますを取得
	 *
	 * @return ランキングの取得位置を指定します
	 */
	public Integer getOffset() {
		return offset;
	}

	/**
	 * ランキングの取得位置を指定しますを設定
	 *
	 * @param offset ランキングの取得位置を指定します
	 */
	public void setOffset(Integer offset) {
		this.offset = offset;
	}

	/**
	 * ランキングの取得位置を指定しますを設定
	 *
	 * @param offset ランキングの取得位置を指定します
	 * @return this
	 */
	public GetRankingRequest withOffset(Integer offset) {
		setOffset(offset);
		return this;
	}

	/**
	 * ランキングの取得件数を指定しますを取得
	 *
	 * @return ランキングの取得件数を指定します
	 */
	public Integer getLimit() {
		return limit;
	}

	/**
	 * ランキングの取得件数を指定しますを設定
	 *
	 * @param limit ランキングの取得件数を指定します
	 */
	public void setLimit(Integer limit) {
		this.limit = limit;
	}

	/**
	 * ランキングの取得件数を指定しますを設定
	 *
	 * @param limit ランキングの取得件数を指定します
	 * @return this
	 */
	public GetRankingRequest withLimit(Integer limit) {
		setLimit(limit);
		return this;
	}

}