/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.watch;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.model.IGs2Credential;
import io.gs2.watch.control.CreateAlermRequest;
import io.gs2.watch.control.CreateAlermResult;
import io.gs2.watch.control.DeleteAlermRequest;
import io.gs2.watch.control.DescribeAlermEventRequest;
import io.gs2.watch.control.DescribeAlermEventResult;
import io.gs2.watch.control.DescribeAlermRequest;
import io.gs2.watch.control.DescribeAlermResult;
import io.gs2.watch.control.DescribeOperationRequest;
import io.gs2.watch.control.DescribeOperationResult;
import io.gs2.watch.control.DescribeServiceRequest;
import io.gs2.watch.control.DescribeServiceResult;
import io.gs2.watch.control.GetAlermRequest;
import io.gs2.watch.control.GetAlermResult;
import io.gs2.watch.control.GetMetricRequest;
import io.gs2.watch.control.GetMetricResult;
import io.gs2.watch.control.UpdateAlermRequest;
import io.gs2.watch.control.UpdateAlermResult;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2WatchClient
extends AbstractGs2Client<Gs2WatchClient> {
    public static String ENDPOINT = "watch";

    public Gs2WatchClient(IGs2Credential credential) {
        super(credential);
    }

    public CreateAlermResult createAlerm(CreateAlermRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName()).put("description", request.getDescription()).put("service", request.getService()).put("serviceId", request.getServiceId()).put("operation", request.getOperation()).put("expression", request.getExpression()).put("threshold", request.getThreshold()).put("notificationId", request.getNotificationId());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/alerm", this.credential, ENDPOINT, "Gs2Watch", "CreateAlerm", body.toString());
        return (CreateAlermResult)this.doRequest((HttpUriRequest)post, CreateAlermResult.class);
    }

    public DescribeAlermResult describeAlerm(DescribeAlermRequest request) {
        String url = "https://{service}.{region}.gs2.io/alerm";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", request.getPageToken()));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Watch", "DescribeAlerm");
        return (DescribeAlermResult)this.doRequest((HttpUriRequest)get, DescribeAlermResult.class);
    }

    public GetAlermResult getAlerm(GetAlermRequest request) {
        HttpGet get = this.createHttpGet("https://{service}.{region}.gs2.io/alerm/" + request.getAlermName(), this.credential, ENDPOINT, "Gs2Watch", "GetAlerm");
        return (GetAlermResult)this.doRequest((HttpUriRequest)get, GetAlermResult.class);
    }

    public UpdateAlermResult updateAlerm(UpdateAlermRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("description", request.getDescription()).put("expression", request.getExpression()).put("threshold", request.getThreshold()).put("notificationId", request.getNotificationId());
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/alerm/" + request.getAlermName(), this.credential, ENDPOINT, "Gs2Watch", "UpdateAlerm", body.toString());
        return (UpdateAlermResult)this.doRequest((HttpUriRequest)put, UpdateAlermResult.class);
    }

    public void deleteAlerm(DeleteAlermRequest request) {
        HttpDelete delete = this.createHttpDelete("https://{service}.{region}.gs2.io/alerm/" + request.getAlermName(), this.credential, ENDPOINT, "Gs2Watch", "DeleteAlerm");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeAlermEventResult describeAlermEvent(DescribeAlermEventRequest request) {
        String url = "https://{service}.{region}.gs2.io/alerm/" + request.getAlermName() + "/event";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", request.getPageToken()));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Watch", "DescribeAlermEvent");
        return (DescribeAlermEventResult)this.doRequest((HttpUriRequest)get, DescribeAlermEventResult.class);
    }

    public DescribeServiceResult describeService(DescribeServiceRequest request) {
        String url = "https://{service}.{region}.gs2.io/service";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Watch", "DescribeService");
        return (DescribeServiceResult)this.doRequest((HttpUriRequest)get, DescribeServiceResult.class);
    }

    public DescribeOperationResult describeOperation(DescribeOperationRequest request) {
        String url = "https://{service}.{region}.gs2.io/service/" + request.getService() + "/operation";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Watch", "DescribeOperation");
        return (DescribeOperationResult)this.doRequest((HttpUriRequest)get, DescribeOperationResult.class);
    }

    public GetMetricResult getMetric(GetMetricRequest request) {
        String url = "https://{service}.{region}.gs2.io/metric/" + request.getServiceId() + "/" + request.getOperation();
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getBegin() != null) {
            queryString.add(new BasicNameValuePair("begin", String.valueOf(request.getBegin())));
        }
        if (request.getEnd() != null) {
            queryString.add(new BasicNameValuePair("end", String.valueOf(request.getEnd())));
        }
        if (request.getAllowLongTerm() != null) {
            queryString.add(new BasicNameValuePair("allowLongTerm", String.valueOf(request.getAllowLongTerm())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Watch", "GetMetric");
        return (GetMetricResult)this.doRequest((HttpUriRequest)get, GetMetricResult.class);
    }
}

