/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.sdk.core.client;

import io.hackle.sdk.common.Event;
import io.hackle.sdk.common.Variation;
import io.hackle.sdk.common.decision.Decision;
import io.hackle.sdk.common.decision.DecisionReason;
import io.hackle.sdk.common.decision.FeatureFlagDecision;
import io.hackle.sdk.core.evaluation.Evaluation;
import io.hackle.sdk.core.evaluation.Evaluator;
import io.hackle.sdk.core.event.EventProcessor;
import io.hackle.sdk.core.event.UserEvent;
import io.hackle.sdk.core.internal.utils.AnyKt;
import io.hackle.sdk.core.model.EventType;
import io.hackle.sdk.core.model.Experiment;
import io.hackle.sdk.core.model.HackleUser;
import io.hackle.sdk.core.workspace.Workspace;
import io.hackle.sdk.core.workspace.WorkspaceFetcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/hackle/sdk/core/client/HackleInternalClient;", "Ljava/lang/AutoCloseable;", "evaluator", "Lio/hackle/sdk/core/evaluation/Evaluator;", "workspaceFetcher", "Lio/hackle/sdk/core/workspace/WorkspaceFetcher;", "eventProcessor", "Lio/hackle/sdk/core/event/EventProcessor;", "(Lio/hackle/sdk/core/evaluation/Evaluator;Lio/hackle/sdk/core/workspace/WorkspaceFetcher;Lio/hackle/sdk/core/event/EventProcessor;)V", "close", "", "experiment", "Lio/hackle/sdk/common/decision/Decision;", "experimentKey", "", "user", "Lio/hackle/sdk/core/model/HackleUser;", "defaultVariation", "Lio/hackle/sdk/common/Variation;", "featureFlag", "Lio/hackle/sdk/common/decision/FeatureFlagDecision;", "featureKey", "track", "event", "Lio/hackle/sdk/common/Event;", "hackle-sdk-core"})
public final class HackleInternalClient
implements AutoCloseable {
    private final Evaluator evaluator;
    private final WorkspaceFetcher workspaceFetcher;
    private final EventProcessor eventProcessor;

    @NotNull
    public final Decision experiment(long experimentKey, @NotNull HackleUser user, @NotNull Variation defaultVariation) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)defaultVariation, (String)"defaultVariation");
        Workspace workspace = this.workspaceFetcher.fetch();
        if (workspace == null) {
            return Decision.Companion.of(defaultVariation, DecisionReason.SDK_NOT_READY);
        }
        Workspace workspace2 = workspace;
        Experiment experiment = workspace2.getExperimentOrNull(experimentKey);
        if (experiment == null) {
            return Decision.Companion.of(defaultVariation, DecisionReason.EXPERIMENT_NOT_FOUND);
        }
        Experiment experiment2 = experiment;
        Evaluation evaluation = this.evaluator.evaluate(workspace2, experiment2, user, defaultVariation.name());
        this.eventProcessor.process(UserEvent.Companion.exposure$hackle_sdk_core(experiment2, user, evaluation));
        return Decision.Companion.of(Variation.Companion.from(evaluation.getVariationKey()), evaluation.getReason());
    }

    @NotNull
    public final FeatureFlagDecision featureFlag(long featureKey, @NotNull HackleUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Workspace workspace = this.workspaceFetcher.fetch();
        if (workspace == null) {
            return FeatureFlagDecision.Companion.off(DecisionReason.SDK_NOT_READY);
        }
        Workspace workspace2 = workspace;
        Experiment experiment = workspace2.getFeatureFlagOrNull(featureKey);
        if (experiment == null) {
            return FeatureFlagDecision.Companion.off(DecisionReason.FEATURE_FLAG_NOT_FOUND);
        }
        Experiment featureFlag = experiment;
        Evaluation evaluation = this.evaluator.evaluate(workspace2, featureFlag, user, Variation.CONTROL.name());
        this.eventProcessor.process(UserEvent.Companion.exposure$hackle_sdk_core(featureFlag, user, evaluation));
        Variation variation = Variation.Companion.from(evaluation.getVariationKey());
        return variation.isControl() ? FeatureFlagDecision.Companion.off(evaluation.getReason()) : FeatureFlagDecision.Companion.on(evaluation.getReason());
    }

    public final void track(@NotNull Event event, @NotNull HackleUser user) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Object object = this.workspaceFetcher.fetch();
        if (object == null || (object = object.getEventTypeOrNull(event.getKey())) == null) {
            object = new EventType.Undefined(event.getKey());
        }
        Object eventType = object;
        this.eventProcessor.process(UserEvent.Companion.track$hackle_sdk_core((EventType)eventType, event, user));
    }

    @Override
    public void close() {
        AnyKt.tryClose(this.workspaceFetcher);
        AnyKt.tryClose(this.eventProcessor);
    }

    public HackleInternalClient(@NotNull Evaluator evaluator, @NotNull WorkspaceFetcher workspaceFetcher, @NotNull EventProcessor eventProcessor) {
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        Intrinsics.checkNotNullParameter((Object)workspaceFetcher, (String)"workspaceFetcher");
        Intrinsics.checkNotNullParameter((Object)eventProcessor, (String)"eventProcessor");
        this.evaluator = evaluator;
        this.workspaceFetcher = workspaceFetcher;
        this.eventProcessor = eventProcessor;
    }
}

