/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.sdk.core.evaluation.action;

import io.hackle.sdk.core.evaluation.bucket.Bucketer;
import io.hackle.sdk.core.model.Action;
import io.hackle.sdk.core.model.Bucket;
import io.hackle.sdk.core.model.Experiment;
import io.hackle.sdk.core.model.HackleUser;
import io.hackle.sdk.core.model.Slot;
import io.hackle.sdk.core.model.Variation;
import io.hackle.sdk.core.workspace.Workspace;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/hackle/sdk/core/evaluation/action/ActionResolver;", "", "bucketer", "Lio/hackle/sdk/core/evaluation/bucket/Bucketer;", "(Lio/hackle/sdk/core/evaluation/bucket/Bucketer;)V", "resolveBucket", "Lio/hackle/sdk/core/model/Variation;", "action", "Lio/hackle/sdk/core/model/Action$Bucket;", "workspace", "Lio/hackle/sdk/core/workspace/Workspace;", "experiment", "Lio/hackle/sdk/core/model/Experiment;", "user", "Lio/hackle/sdk/core/model/HackleUser;", "resolveOrNull", "Lio/hackle/sdk/core/model/Action;", "resolveVariation", "Lio/hackle/sdk/core/model/Action$Variation;", "hackle-sdk-core"})
public final class ActionResolver {
    private final Bucketer bucketer;

    @Nullable
    public final Variation resolveOrNull(@NotNull Action action, @NotNull Workspace workspace, @NotNull Experiment experiment, @NotNull HackleUser user) {
        Variation variation;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)experiment, (String)"experiment");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Action action2 = action;
        if (action2 instanceof Action.Variation) {
            variation = this.resolveVariation((Action.Variation)action, experiment);
        } else if (action2 instanceof Action.Bucket) {
            variation = this.resolveBucket((Action.Bucket)action, workspace, experiment, user);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return variation;
    }

    private final Variation resolveVariation(Action.Variation action, Experiment experiment) {
        Variation variation = experiment.getVariationOrNull$hackle_sdk_core(action.getVariationId());
        boolean bl = false;
        boolean bl2 = false;
        if (variation == null) {
            boolean bl3 = false;
            String string = "variation[" + action.getVariationId() + ']';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return variation;
    }

    private final Variation resolveBucket(Action.Bucket action, Workspace workspace, Experiment experiment, HackleUser user) {
        Bucket bucket = workspace.getBucketOrNull(action.getBucketId());
        boolean bl = false;
        boolean bl2 = false;
        if (bucket == null) {
            boolean bl3 = false;
            String string = "bucket[" + action.getBucketId() + ']';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Bucket bucket2 = bucket;
        String string = (String)user.getIdentifiers().get((Object)experiment.getIdentifierType());
        if (string == null) {
            return null;
        }
        String identifier = string;
        Slot slot = this.bucketer.bucketing(bucket2, identifier);
        if (slot == null) {
            return null;
        }
        Slot allocatedSlot = slot;
        return experiment.getVariationOrNull$hackle_sdk_core(allocatedSlot.getVariationId());
    }

    public ActionResolver(@NotNull Bucketer bucketer) {
        Intrinsics.checkNotNullParameter((Object)bucketer, (String)"bucketer");
        this.bucketer = bucketer;
    }
}

