/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.sdk.core.evaluation.bucket;

import io.hackle.sdk.core.evaluation.bucket.Murmur3;
import io.hackle.sdk.core.model.Bucket;
import io.hackle.sdk.core.model.Slot;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Lio/hackle/sdk/core/evaluation/bucket/Bucketer;", "", "()V", "bucketing", "Lio/hackle/sdk/core/model/Slot;", "bucket", "Lio/hackle/sdk/core/model/Bucket;", "identifier", "", "calculateSlotNumber", "", "seed", "slotSize", "value", "hackle-sdk-core"})
public final class Bucketer {
    @Nullable
    public final Slot bucketing(@NotNull Bucket bucket, @NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        int slotNumber = this.calculateSlotNumber(bucket.getSeed(), bucket.getSlotSize(), identifier);
        return bucket.getSlotOrNull(slotNumber);
    }

    public final int calculateSlotNumber(int seed, int slotSize, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int hashValue = Murmur3.INSTANCE.murmurhash3_x86_32(value, seed);
        return Math.abs(hashValue) % slotSize;
    }
}

