/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.sdk.core.evaluation.flow;

import io.hackle.sdk.common.decision.DecisionReason;
import io.hackle.sdk.core.evaluation.Evaluation;
import io.hackle.sdk.core.evaluation.flow.FlowEvaluator;
import io.hackle.sdk.core.model.Experiment;
import io.hackle.sdk.core.model.HackleUser;
import io.hackle.sdk.core.workspace.Workspace;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \r2\u00020\u0001:\u0003\r\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow;", "", "()V", "evaluate", "Lio/hackle/sdk/core/evaluation/Evaluation;", "workspace", "Lio/hackle/sdk/core/workspace/Workspace;", "experiment", "Lio/hackle/sdk/core/model/Experiment;", "user", "Lio/hackle/sdk/core/model/HackleUser;", "defaultVariationKey", "", "Companion", "Decision", "End", "Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow$End;", "Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow$Decision;", "hackle-sdk-core"})
public abstract class EvaluationFlow {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Evaluation evaluate(@NotNull Workspace workspace, @NotNull Experiment experiment, @NotNull HackleUser user, @NotNull String defaultVariationKey) {
        Evaluation evaluation;
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)experiment, (String)"experiment");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)defaultVariationKey, (String)"defaultVariationKey");
        EvaluationFlow evaluationFlow = this;
        if (evaluationFlow instanceof End) {
            evaluation = Evaluation.Companion.of(experiment, defaultVariationKey, DecisionReason.TRAFFIC_NOT_ALLOCATED);
        } else if (evaluationFlow instanceof Decision) {
            evaluation = ((Decision)this).getFlowEvaluator().evaluate(workspace, experiment, user, defaultVariationKey, ((Decision)this).getNextFlow());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return evaluation;
    }

    private EvaluationFlow() {
    }

    public /* synthetic */ EvaluationFlow(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow$End;", "Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow;", "()V", "hackle-sdk-core"})
    public static final class End
    extends EvaluationFlow {
        public static final End INSTANCE;

        private End() {
            super(null);
        }

        static {
            End end;
            INSTANCE = end = new End();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow$Decision;", "Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow;", "flowEvaluator", "Lio/hackle/sdk/core/evaluation/flow/FlowEvaluator;", "nextFlow", "(Lio/hackle/sdk/core/evaluation/flow/FlowEvaluator;Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow;)V", "getFlowEvaluator", "()Lio/hackle/sdk/core/evaluation/flow/FlowEvaluator;", "getNextFlow", "()Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow;", "hackle-sdk-core"})
    public static final class Decision
    extends EvaluationFlow {
        @NotNull
        private final FlowEvaluator flowEvaluator;
        @NotNull
        private final EvaluationFlow nextFlow;

        @NotNull
        public final FlowEvaluator getFlowEvaluator() {
            return this.flowEvaluator;
        }

        @NotNull
        public final EvaluationFlow getNextFlow() {
            return this.nextFlow;
        }

        public Decision(@NotNull FlowEvaluator flowEvaluator, @NotNull EvaluationFlow nextFlow) {
            Intrinsics.checkNotNullParameter((Object)flowEvaluator, (String)"flowEvaluator");
            Intrinsics.checkNotNullParameter((Object)nextFlow, (String)"nextFlow");
            super(null);
            this.flowEvaluator = flowEvaluator;
            this.nextFlow = nextFlow;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow$Companion;", "", "()V", "of", "Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow;", "evaluators", "", "Lio/hackle/sdk/core/evaluation/flow/FlowEvaluator;", "([Lio/hackle/sdk/core/evaluation/flow/FlowEvaluator;)Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow;", "hackle-sdk-core"})
    public static final class Companion {
        @NotNull
        public final EvaluationFlow of(FlowEvaluator ... evaluators) {
            Intrinsics.checkNotNullParameter((Object)evaluators, (String)"evaluators");
            EvaluationFlow flow = End.INSTANCE;
            ListIterator iterator = ArraysKt.toList((Object[])evaluators).listIterator(evaluators.length);
            while (iterator.hasPrevious()) {
                flow = new Decision((FlowEvaluator)iterator.previous(), flow);
            }
            return flow;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

