/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.sdk.core.evaluation.flow;

import io.hackle.sdk.core.evaluation.action.ActionResolver;
import io.hackle.sdk.core.evaluation.bucket.Bucketer;
import io.hackle.sdk.core.evaluation.flow.CompletedExperimentEvaluator;
import io.hackle.sdk.core.evaluation.flow.DefaultRuleEvaluator;
import io.hackle.sdk.core.evaluation.flow.DraftExperimentEvaluator;
import io.hackle.sdk.core.evaluation.flow.EvaluationFlow;
import io.hackle.sdk.core.evaluation.flow.EvaluationFlowFactory$WhenMappings;
import io.hackle.sdk.core.evaluation.flow.ExperimentTargetEvaluator;
import io.hackle.sdk.core.evaluation.flow.OverrideEvaluator;
import io.hackle.sdk.core.evaluation.flow.PausedExperimentEvaluator;
import io.hackle.sdk.core.evaluation.flow.TargetRuleEvaluator;
import io.hackle.sdk.core.evaluation.flow.TrafficAllocateEvaluator;
import io.hackle.sdk.core.evaluation.match.ConditionMatcherFactory;
import io.hackle.sdk.core.evaluation.match.TargetMatcher;
import io.hackle.sdk.core.evaluation.target.ExperimentTargetDeterminer;
import io.hackle.sdk.core.evaluation.target.OverrideResolver;
import io.hackle.sdk.core.evaluation.target.TargetRuleDeterminer;
import io.hackle.sdk.core.model.Experiment;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/hackle/sdk/core/evaluation/flow/EvaluationFlowFactory;", "", "()V", "abTestFlow", "Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow;", "featureFlagFlow", "getFlow", "experimentType", "Lio/hackle/sdk/core/model/Experiment$Type;", "hackle-sdk-core"})
public final class EvaluationFlowFactory {
    private final EvaluationFlow abTestFlow;
    private final EvaluationFlow featureFlagFlow;

    @NotNull
    public final EvaluationFlow getFlow(@NotNull Experiment.Type experimentType) {
        EvaluationFlow evaluationFlow;
        Intrinsics.checkNotNullParameter((Object)((Object)experimentType), (String)"experimentType");
        switch (EvaluationFlowFactory$WhenMappings.$EnumSwitchMapping$0[experimentType.ordinal()]) {
            case 1: {
                evaluationFlow = this.abTestFlow;
                break;
            }
            case 2: {
                evaluationFlow = this.featureFlagFlow;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return evaluationFlow;
    }

    public EvaluationFlowFactory() {
        TargetMatcher targetMatcher = new TargetMatcher(new ConditionMatcherFactory());
        ActionResolver actionResolver = new ActionResolver(new Bucketer());
        OverrideResolver overrideResolver = new OverrideResolver(targetMatcher, actionResolver);
        EvaluationFlow abTestFlow = EvaluationFlow.Companion.of(new OverrideEvaluator(overrideResolver), new ExperimentTargetEvaluator(new ExperimentTargetDeterminer(targetMatcher)), new DraftExperimentEvaluator(), new PausedExperimentEvaluator(), new CompletedExperimentEvaluator(), new TrafficAllocateEvaluator(actionResolver));
        EvaluationFlow featureFlagFlow = EvaluationFlow.Companion.of(new DraftExperimentEvaluator(), new PausedExperimentEvaluator(), new CompletedExperimentEvaluator(), new OverrideEvaluator(overrideResolver), new TargetRuleEvaluator(new TargetRuleDeterminer(targetMatcher), actionResolver), new DefaultRuleEvaluator(actionResolver));
        this.abTestFlow = abTestFlow;
        this.featureFlagFlow = featureFlagFlow;
    }
}

