/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.sdk.core.evaluation.flow;

import io.hackle.sdk.common.decision.DecisionReason;
import io.hackle.sdk.core.evaluation.Evaluation;
import io.hackle.sdk.core.evaluation.flow.EvaluationFlow;
import io.hackle.sdk.core.evaluation.flow.FlowEvaluator;
import io.hackle.sdk.core.evaluation.target.ExperimentTargetDeterminer;
import io.hackle.sdk.core.model.Experiment;
import io.hackle.sdk.core.model.HackleUser;
import io.hackle.sdk.core.workspace.Workspace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/hackle/sdk/core/evaluation/flow/ExperimentTargetEvaluator;", "Lio/hackle/sdk/core/evaluation/flow/FlowEvaluator;", "experimentTargetDeterminer", "Lio/hackle/sdk/core/evaluation/target/ExperimentTargetDeterminer;", "(Lio/hackle/sdk/core/evaluation/target/ExperimentTargetDeterminer;)V", "evaluate", "Lio/hackle/sdk/core/evaluation/Evaluation;", "workspace", "Lio/hackle/sdk/core/workspace/Workspace;", "experiment", "Lio/hackle/sdk/core/model/Experiment;", "user", "Lio/hackle/sdk/core/model/HackleUser;", "defaultVariationKey", "", "nextFlow", "Lio/hackle/sdk/core/evaluation/flow/EvaluationFlow;", "hackle-sdk-core"})
public final class ExperimentTargetEvaluator
implements FlowEvaluator {
    private final ExperimentTargetDeterminer experimentTargetDeterminer;

    @Override
    @NotNull
    public Evaluation evaluate(@NotNull Workspace workspace, @NotNull Experiment experiment, @NotNull HackleUser user, @NotNull String defaultVariationKey, @NotNull EvaluationFlow nextFlow) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)experiment, (String)"experiment");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)defaultVariationKey, (String)"defaultVariationKey");
        Intrinsics.checkNotNullParameter((Object)nextFlow, (String)"nextFlow");
        boolean bl = experiment.getType() == Experiment.Type.AB_TEST;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "experiment type must be AB_TEST [" + experiment.getId() + ']';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean isUserInExperimentTarget = this.experimentTargetDeterminer.isUserInExperimentTarget(workspace, experiment, user);
        return isUserInExperimentTarget ? nextFlow.evaluate(workspace, experiment, user, defaultVariationKey) : Evaluation.Companion.of(experiment, defaultVariationKey, DecisionReason.NOT_IN_EXPERIMENT_TARGET);
    }

    public ExperimentTargetEvaluator(@NotNull ExperimentTargetDeterminer experimentTargetDeterminer) {
        Intrinsics.checkNotNullParameter((Object)experimentTargetDeterminer, (String)"experimentTargetDeterminer");
        this.experimentTargetDeterminer = experimentTargetDeterminer;
    }
}

