/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.sdk.core.internal.scheduler;

import io.hackle.sdk.core.internal.scheduler.ScheduledJob;
import io.hackle.sdk.core.internal.scheduler.Scheduler;
import io.hackle.sdk.core.internal.scheduler.Schedulers$sam$java_lang_Runnable$0;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lio/hackle/sdk/core/internal/scheduler/Schedulers;", "", "()V", "executor", "Lio/hackle/sdk/core/internal/scheduler/Scheduler;", "Ljava/util/concurrent/ScheduledExecutorService;", "ExecutorScheduler", "hackle-sdk-core"})
public final class Schedulers {
    public static final Schedulers INSTANCE;

    @NotNull
    public final Scheduler executor(@NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return new ExecutorScheduler(executor);
    }

    private Schedulers() {
    }

    static {
        Schedulers schedulers;
        INSTANCE = schedulers = new Schedulers();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0016J.\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/hackle/sdk/core/internal/scheduler/Schedulers$ExecutorScheduler;", "Lio/hackle/sdk/core/internal/scheduler/Scheduler;", "Ljava/lang/AutoCloseable;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Ljava/util/concurrent/ScheduledExecutorService;)V", "close", "", "schedule", "Lio/hackle/sdk/core/internal/scheduler/ScheduledJob;", "delay", "", "unit", "Ljava/util/concurrent/TimeUnit;", "task", "Lkotlin/Function0;", "schedulePeriodically", "period", "Job", "hackle-sdk-core"})
    private static final class ExecutorScheduler
    implements Scheduler,
    AutoCloseable {
        private final ScheduledExecutorService executor;

        @Override
        @NotNull
        public ScheduledJob schedule(long delay, @NotNull TimeUnit unit, @NotNull Function0<Unit> task) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            Intrinsics.checkNotNullParameter(task, (String)"task");
            Function0<Unit> function0 = task;
            ScheduledFuture<?> scheduledFuture = this.executor.schedule(new Schedulers$sam$java_lang_Runnable$0(function0), delay, unit);
            Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"executor.schedule(task, delay, unit)");
            return new Job(scheduledFuture);
        }

        @Override
        @NotNull
        public ScheduledJob schedulePeriodically(long delay, long period, @NotNull TimeUnit unit, @NotNull Function0<Unit> task) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            Intrinsics.checkNotNullParameter(task, (String)"task");
            Function0<Unit> function0 = task;
            ScheduledFuture<?> scheduledFuture = this.executor.scheduleAtFixedRate(new Schedulers$sam$java_lang_Runnable$0(function0), delay, period, unit);
            Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"executor.scheduleAtFixed\u2026ask, delay, period, unit)");
            return new Job(scheduledFuture);
        }

        @Override
        public void close() {
            this.executor.shutdownNow();
        }

        public ExecutorScheduler(@NotNull ScheduledExecutorService executor) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            this.executor = executor;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/hackle/sdk/core/internal/scheduler/Schedulers$ExecutorScheduler$Job;", "Lio/hackle/sdk/core/internal/scheduler/ScheduledJob;", "real", "Ljava/util/concurrent/ScheduledFuture;", "(Ljava/util/concurrent/ScheduledFuture;)V", "cancel", "", "hackle-sdk-core"})
        private static final class Job
        implements ScheduledJob {
            private final ScheduledFuture<?> real;

            @Override
            public void cancel() {
                this.real.cancel(false);
            }

            public Job(@NotNull ScheduledFuture<?> real) {
                Intrinsics.checkNotNullParameter(real, (String)"real");
                this.real = real;
            }
        }
    }
}

