/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.sdk.core.internal.threads;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lio/hackle/sdk/core/internal/threads/PoolingExecutors;", "", "()V", "newThreadPool", "Ljava/util/concurrent/ExecutorService;", "poolSize", "", "workQueueCapacity", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "hackle-sdk-core"})
public final class PoolingExecutors {
    public static final PoolingExecutors INSTANCE;

    @NotNull
    public final ExecutorService newThreadPool(int poolSize, int workQueueCapacity, @NotNull ThreadFactory threadFactory) {
        Intrinsics.checkNotNullParameter((Object)threadFactory, (String)"threadFactory");
        return new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new ArrayBlockingQueue(workQueueCapacity), threadFactory);
    }

    private PoolingExecutors() {
    }

    static {
        PoolingExecutors poolingExecutors;
        INSTANCE = poolingExecutors = new PoolingExecutors();
    }
}

