/*
 * Decompiled with CFR 0.152.
 */
package io.hackle.sdk.core.model;

import io.hackle.sdk.core.model.CoreVersion;
import io.hackle.sdk.core.model.MetadataVersion;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u001a"}, d2={"Lio/hackle/sdk/core/model/Version;", "", "coreVersion", "Lio/hackle/sdk/core/model/CoreVersion;", "prerelease", "Lio/hackle/sdk/core/model/MetadataVersion;", "build", "(Lio/hackle/sdk/core/model/CoreVersion;Lio/hackle/sdk/core/model/MetadataVersion;Lio/hackle/sdk/core/model/MetadataVersion;)V", "getBuild", "()Lio/hackle/sdk/core/model/MetadataVersion;", "getCoreVersion", "()Lio/hackle/sdk/core/model/CoreVersion;", "plainString", "", "getPlainString", "()Ljava/lang/String;", "getPrerelease", "compareTo", "", "other", "equals", "", "", "hashCode", "toString", "Companion", "hackle-sdk-core"})
public final class Version
implements Comparable<Version> {
    @NotNull
    private final CoreVersion coreVersion;
    @NotNull
    private final MetadataVersion prerelease;
    @NotNull
    private final MetadataVersion build;
    private static final Pattern PATTERN;
    public static final Companion Companion;

    @NotNull
    public final String getPlainString() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append(this.coreVersion);
        if (this.prerelease.isNotEmpty()) {
            $this$buildString.append("-");
            $this$buildString.append(this.prerelease);
        }
        if (this.build.isNotEmpty()) {
            $this$buildString.append("+");
            $this$buildString.append(this.build);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    public int compareTo(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int result = this.coreVersion.compareTo(other.coreVersion);
        if (result != 0) {
            return result;
        }
        return this.prerelease.compareTo(other.prerelease);
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof Version) ? false : this.compareTo((Version)other) == 0);
    }

    public int hashCode() {
        return Objects.hash(this.coreVersion, this.prerelease);
    }

    @NotNull
    public String toString() {
        return "Version(" + this.getPlainString() + ')';
    }

    @NotNull
    public final CoreVersion getCoreVersion() {
        return this.coreVersion;
    }

    @NotNull
    public final MetadataVersion getPrerelease() {
        return this.prerelease;
    }

    @NotNull
    public final MetadataVersion getBuild() {
        return this.build;
    }

    private Version(CoreVersion coreVersion, MetadataVersion prerelease, MetadataVersion build) {
        this.coreVersion = coreVersion;
        this.prerelease = prerelease;
        this.build = build;
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("^(0|[1-9]\\d*)(?:\\.(0|[1-9]\\d*))?(?:\\.(0|[1-9]\\d*))?(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\n       \u2026-]+)*))?\\$\"\n            )");
        PATTERN = pattern;
    }

    public /* synthetic */ Version(CoreVersion coreVersion, MetadataVersion prerelease, MetadataVersion build, DefaultConstructorMarker $constructor_marker) {
        this(coreVersion, prerelease, build);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0001J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/hackle/sdk/core/model/Version$Companion;", "", "()V", "PATTERN", "Ljava/util/regex/Pattern;", "parseOrNull", "Lio/hackle/sdk/core/model/Version;", "value", "version", "", "hackle-sdk-core"})
    public static final class Companion {
        @Nullable
        public final Version parseOrNull(@NotNull String version) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Matcher matcher = PATTERN.matcher(version);
            if (!matcher.matches()) {
                return null;
            }
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
            String string2 = string;
            boolean bl = false;
            int major = Integer.parseInt(string2);
            String string3 = matcher.group(2);
            if (string3 != null) {
                String string4 = string3;
                boolean bl2 = false;
                n2 = Integer.parseInt(string4);
            } else {
                n2 = 0;
            }
            int minor = n2;
            String string5 = matcher.group(3);
            if (string5 != null) {
                String string6 = string5;
                boolean bl3 = false;
                n = Integer.parseInt(string6);
            } else {
                n = 0;
            }
            int patch = n;
            CoreVersion coreVersion = new CoreVersion(major, minor, patch);
            MetadataVersion prerelease = MetadataVersion.Companion.parse(matcher.group(4));
            MetadataVersion build = MetadataVersion.Companion.parse(matcher.group(5));
            return new Version(coreVersion, prerelease, build, null);
        }

        @Nullable
        public final Version parseOrNull(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object object = value;
            return object instanceof Version ? (Version)value : (!(object instanceof String) ? null : this.parseOrNull((String)value));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

