/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.example.spring.boot;

import io.hawt.example.spring.boot.KeycloakConfiguration;
import io.hawt.springboot.EndpointPathResolver;
import jakarta.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class KeycloakConfiguration {
    private final EndpointPathResolver endpointPath;

    public KeycloakConfiguration(EndpointPathResolver endpointPath) {
        this.endpointPath = endpointPath;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        String hawtioPath = this.endpointPath.resolve("hawtio");
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)(hawtioPath + "/css/**"))})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)(hawtioPath + "/fonts/**"))})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)(hawtioPath + "/img/**"))})).permitAll().anyRequest()).authenticated()).oauth2Client(Customizer.withDefaults()).oauth2Login(Customizer.withDefaults()).csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).csrfTokenRequestHandler((CsrfTokenRequestHandler)new SpaCsrfTokenRequestHandler())).addFilterAfter((Filter)new CsrfCookieFilter(), BasicAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }
}

