/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.git;

import io.hawt.git.CommitInfo;
import io.hawt.git.CommitTreeInfo;
import io.hawt.git.FileContents;
import io.hawt.git.FileInfo;
import io.hawt.git.GitFacade;
import io.hawt.git.GitFacadeMXBean;
import io.hawt.git.RuntimeIOException;
import io.hawt.util.FileFilters;
import io.hawt.util.IOHelper;
import io.hawt.util.MBeanSupport;
import io.hawt.util.Objects;
import io.hawt.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.gitective.core.BlobUtils;
import org.gitective.core.CommitFinder;
import org.gitective.core.CommitUtils;
import org.gitective.core.PathFilterUtils;
import org.gitective.core.filter.commit.CommitLimitFilter;
import org.gitective.core.filter.commit.CommitListFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GitFacadeSupport
extends MBeanSupport
implements GitFacadeMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitFacadeSupport.class);
    private int shortCommitIdLength = 6;
    private String repositoryLabel = "Wiki";

    public void setRepositoryLabel(String repositoryLabel) {
        this.repositoryLabel = repositoryLabel;
    }

    @Override
    public String getRepositoryLabel() {
        return this.repositoryLabel;
    }

    protected String doDiff(Git git, String objectId, String baseObjectId, String pathOrBlobPath) {
        Repository r = git.getRepository();
        String blobPath = GitFacade.trimLeadingSlash(pathOrBlobPath);
        RevCommit commit = Strings.isNotBlank(objectId) ? CommitUtils.getCommit(r, objectId) : CommitUtils.getHead(r);
        RevCommit baseCommit = null;
        if (Strings.isNotBlank(baseObjectId)) {
            baseCommit = CommitUtils.getCommit(r, baseObjectId);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        RawTextComparator cmp = RawTextComparator.DEFAULT;
        DiffFormatter formatter = new DiffFormatter(buffer);
        formatter.setRepository(r);
        formatter.setDiffComparator(cmp);
        formatter.setDetectRenames(true);
        RevTree commitTree = commit.getTree();
        try {
            RevTree baseTree;
            if (baseCommit == null) {
                if (commit.getParentCount() > 0) {
                    RevWalk rw = new RevWalk(r);
                    RevCommit parent = rw.parseCommit(commit.getParent(0).getId());
                    rw.dispose();
                    baseTree = parent.getTree();
                } else {
                    baseTree = commitTree;
                }
            } else {
                baseTree = baseCommit.getTree();
            }
            List<DiffEntry> diffEntries = formatter.scan(baseTree, commitTree);
            if (blobPath != null && blobPath.length() > 0) {
                for (DiffEntry diffEntry : diffEntries) {
                    if (!diffEntry.getNewPath().equalsIgnoreCase(blobPath)) continue;
                    formatter.format(diffEntry);
                    break;
                }
            } else {
                formatter.format(diffEntries);
            }
            formatter.flush();
            return buffer.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    protected abstract void checkoutBranch(Git var1, String var2) throws GitAPIException;

    protected abstract boolean isPushOnCommit();

    protected void doCreateBranch(Git git, String fromBranch, String newBranch) throws GitAPIException {
        this.checkoutBranch(git, fromBranch);
        git.branchCreate().setName(newBranch).call();
        this.checkoutBranch(git, newBranch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CommitTreeInfo> doGetCommitTree(Git git, String commitId) {
        Repository repository = git.getRepository();
        ArrayList<CommitTreeInfo> list = new ArrayList<CommitTreeInfo>();
        RevCommit commit = CommitUtils.getCommit(repository, commitId);
        if (commit != null) {
            RevWalk rw = new RevWalk(repository);
            try {
                if (commit.getParentCount() == 0) {
                    TreeWalk treeWalk = new TreeWalk(repository);
                    treeWalk.reset();
                    treeWalk.setRecursive(true);
                    treeWalk.addTree(commit.getTree());
                    while (treeWalk.next()) {
                        String pathString = treeWalk.getPathString();
                        ObjectId objectId = treeWalk.getObjectId(0);
                        int rawMode = treeWalk.getRawMode(0);
                        list.add(new CommitTreeInfo(pathString, pathString, 0L, rawMode, objectId.getName(), commit.getId().getName(), DiffEntry.ChangeType.ADD));
                    }
                    treeWalk.release();
                } else {
                    RevCommit parent = rw.parseCommit(commit.getParent(0).getId());
                    DiffFormatter df = new DiffFormatter(DisabledOutputStream.INSTANCE);
                    df.setRepository(repository);
                    df.setDiffComparator(RawTextComparator.DEFAULT);
                    df.setDetectRenames(true);
                    List<DiffEntry> diffs = df.scan(parent.getTree(), commit.getTree());
                    for (DiffEntry diff : diffs) {
                        String objectId = diff.getNewId().name();
                        if (diff.getChangeType().equals((Object)DiffEntry.ChangeType.DELETE)) {
                            list.add(new CommitTreeInfo(diff.getOldPath(), diff.getOldPath(), 0L, diff.getNewMode().getBits(), objectId, commit.getId().getName(), diff.getChangeType()));
                            continue;
                        }
                        if (diff.getChangeType().equals((Object)DiffEntry.ChangeType.RENAME)) {
                            list.add(new CommitTreeInfo(diff.getOldPath(), diff.getNewPath(), 0L, diff.getNewMode().getBits(), objectId, commit.getId().getName(), diff.getChangeType()));
                            continue;
                        }
                        list.add(new CommitTreeInfo(diff.getNewPath(), diff.getNewPath(), 0L, diff.getNewMode().getBits(), objectId, commit.getId().getName(), diff.getChangeType()));
                    }
                }
            }
            catch (Throwable e) {
                LOG.warn("Failed to walk tree for commit " + commitId + ". " + e, e);
            }
            finally {
                rw.dispose();
            }
        }
        return list;
    }

    protected CommitInfo doGetCommitInfo(Git git, String commitId) {
        Repository repository = git.getRepository();
        RevCommit commit = CommitUtils.getCommit(repository, commitId);
        if (commit == null) {
            return null;
        }
        return this.createCommitInfo(commit);
    }

    protected abstract Iterable<PushResult> doPush(Git var1) throws Exception;

    protected CommitInfo doCreateDirectory(Git git, File rootDir, String branch, String path, PersonIdent personIdent, String commitMessage) throws Exception {
        File file = this.getFile(rootDir, path);
        if (file.exists()) {
            return null;
        }
        file.mkdirs();
        String filePattern = GitFacadeSupport.getFilePattern(path);
        AddCommand add = git.add().addFilepattern(filePattern).addFilepattern(".");
        add.call();
        CommitCommand commit = git.commit().setAll(true).setAuthor(personIdent).setMessage(commitMessage);
        RevCommit revCommit = this.commitThenPush(git, branch, commit);
        return this.createCommitInfo(revCommit);
    }

    protected Void doRevert(Git git, File rootDir, String branch, String objectId, String blobPath, String commitMessage, PersonIdent personIdent) throws Exception {
        String contents = this.doGetContent(git, objectId, blobPath);
        if (contents != null) {
            this.doWrite(git, rootDir, branch, blobPath, contents.getBytes(), personIdent, commitMessage);
        }
        return null;
    }

    protected RevCommit doRename(Git git, File rootDir, String branch, String oldPath, String newPath, String commitMessage, PersonIdent personIdent) throws Exception {
        File file = this.getFile(rootDir, oldPath);
        File newFile = this.getFile(rootDir, newPath);
        if (file.exists()) {
            File parentFile = newFile.getParentFile();
            parentFile.mkdirs();
            if (!parentFile.exists()) {
                throw new IOException("Could not create directory " + parentFile + " when trying to move " + file + " to " + newFile + ". Maybe a file permission issue?");
            }
            file.renameTo(newFile);
            String filePattern = GitFacadeSupport.getFilePattern(newPath);
            git.add().addFilepattern(filePattern).call();
            CommitCommand commit = git.commit().setAll(true).setAuthor(personIdent).setMessage(commitMessage);
            return this.commitThenPush(git, branch, commit);
        }
        return null;
    }

    protected RevCommit doRemove(Git git, File rootDir, String branch, String path, String commitMessage, PersonIdent personIdent) throws Exception {
        File file = this.getFile(rootDir, path);
        if (file.exists()) {
            file.delete();
            String filePattern = GitFacadeSupport.getFilePattern(path);
            git.rm().addFilepattern(filePattern).call();
            CommitCommand commit = git.commit().setAll(true).setAuthor(personIdent).setMessage(commitMessage);
            return this.commitThenPush(git, branch, commit);
        }
        return null;
    }

    protected List<String> doListBranches(Git git) throws GitAPIException {
        TreeSet<String> names = new TreeSet<String>();
        Object call = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
        Iterator i$ = call.iterator();
        while (i$.hasNext()) {
            Ref ref = (Ref)i$.next();
            String name = ref.getName();
            int idx = name.lastIndexOf(47);
            if (idx >= 0) {
                name = name.substring(idx + 1);
            }
            if (name.length() <= 0) continue;
            names.add(name);
        }
        return new ArrayList<String>(names);
    }

    protected String doGetHead(Git git) {
        RevCommit commit = CommitUtils.getHead(git.getRepository());
        return commit.getName();
    }

    protected List<CommitInfo> doHistory(Git git, String branch, String objectId, String pathOrBlobPath, int limit) {
        ArrayList<CommitInfo> results = new ArrayList<CommitInfo>();
        Repository r = git.getRepository();
        try {
            String head = this.getHEAD();
        }
        catch (Exception e) {
            LOG.error("Cannot find HEAD of this git repository! " + e, (Throwable)e);
            return results;
        }
        String path = GitFacade.trimLeadingSlash(pathOrBlobPath);
        CommitFinder finder = new CommitFinder(r);
        CommitListFilter filter = new CommitListFilter();
        if (Strings.isNotBlank(path)) {
            finder.setFilter(PathFilterUtils.and(path));
        }
        finder.setFilter(filter);
        if (limit > 0) {
            finder.setFilter(new CommitLimitFilter(limit).setStop(true));
        }
        if (Strings.isNotBlank(objectId)) {
            finder.findFrom(objectId);
        } else if (Strings.isNotBlank(branch)) {
            ObjectId branchObjectId = this.getBranchObjectId(git, branch);
            finder = branchObjectId != null ? finder.findFrom(branchObjectId) : finder.findInBranches();
        } else {
            finder.find();
        }
        List<RevCommit> commits = filter.getCommits();
        for (RevCommit entry : commits) {
            CommitInfo commitInfo = this.createCommitInfo(entry);
            results.add(commitInfo);
        }
        return results;
    }

    protected ObjectId getBranchObjectId(Git git, String branch) {
        Ref branchRef = null;
        try {
            String branchRevName = "refs/heads/" + branch;
            Object branches = git.branchList().call();
            Iterator i$ = branches.iterator();
            while (i$.hasNext()) {
                Ref ref = (Ref)i$.next();
                String revName = ref.getName();
                if (!Objects.equals(branchRevName, revName)) continue;
                branchRef = ref;
                break;
            }
        }
        catch (GitAPIException e) {
            LOG.warn("Failed to find branches " + e, (Throwable)e);
        }
        ObjectId branchObjectId = null;
        if (branchRef != null) {
            branchObjectId = branchRef.getObjectId();
        }
        return branchObjectId;
    }

    @Override
    protected String getDefaultObjectName() {
        return "hawtio:type=GitFacade";
    }

    protected String doGetContent(Git git, String objectId, String pathOrBlobPath) {
        objectId = this.defaultObjectId(git, objectId);
        Repository r = git.getRepository();
        String blobPath = GitFacade.trimLeadingSlash(pathOrBlobPath);
        return BlobUtils.getContent(r, objectId, blobPath);
    }

    protected String defaultObjectId(Git git, String objectId) {
        if (objectId == null || objectId.trim().length() == 0) {
            RevCommit commit = CommitUtils.getHead(git.getRepository());
            objectId = commit.getName();
        }
        return objectId;
    }

    protected FileContents doRead(Git git, File rootDir, String branch, String pathOrEmpty) throws IOException, GitAPIException {
        this.checkoutBranch(git, branch);
        String path = Strings.isBlank(pathOrEmpty) ? "/" : pathOrEmpty;
        File file = this.getFile(rootDir, path);
        if (file.isFile()) {
            String contents = IOHelper.readFully(file);
            return new FileContents(false, contents, null);
        }
        ArrayList<FileInfo> children = new ArrayList<FileInfo>();
        if (file.exists()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                if (this.isIgnoreFile(child)) continue;
                children.add(FileInfo.createFileInfo(rootDir, child));
            }
        }
        return new FileContents(file.isDirectory(), null, children);
    }

    protected FileInfo doExists(Git git, File rootDir, String branch, String pathOrEmpty) throws GitAPIException {
        this.checkoutBranch(git, branch);
        String path = Strings.isBlank(pathOrEmpty) ? "/" : pathOrEmpty;
        File file = this.getFile(rootDir, path);
        if (file.exists()) {
            return FileInfo.createFileInfo(rootDir, file);
        }
        return null;
    }

    protected List<String> doCompletePath(Git git, File rootDir, String branch, String completionText, boolean directoriesOnly) throws GitAPIException {
        this.checkoutBranch(git, branch);
        boolean empty = Strings.isBlank(completionText);
        String pattern = completionText;
        File file = this.getFile(rootDir, completionText);
        String prefix = completionText;
        if (file.exists()) {
            pattern = "";
        } else {
            int idx;
            String startPath = ".";
            if (!empty && (idx = completionText.lastIndexOf(47)) >= 0) {
                startPath = completionText.substring(0, idx);
                if (startPath.length() == 0) {
                    startPath = "/";
                }
                pattern = completionText.substring(idx + 1);
            }
            file = this.getFile(rootDir, startPath);
            prefix = startPath;
        }
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if (prefix.equals("./")) {
            prefix = "";
        }
        File[] list = file.listFiles();
        ArrayList<String> answer = new ArrayList<String>();
        for (File aFile : list) {
            String name = aFile.getName();
            if (pattern.length() != 0 && !name.contains(pattern) || this.isIgnoreFile(aFile) || directoriesOnly && !aFile.isDirectory()) continue;
            answer.add(prefix + name);
        }
        return answer;
    }

    protected String doReadJsonChildContent(Git git, File rootDir, String branch, String path, String fileNameWildcard, String search) throws GitAPIException, IOException {
        this.checkoutBranch(git, branch);
        File file = this.getFile(rootDir, path);
        FileFilter filter = FileFilters.createFileFilter(fileNameWildcard);
        boolean first = true;
        StringBuilder buffer = new StringBuilder("{\n");
        ArrayList<FileInfo> children = new ArrayList<FileInfo>();
        if (file.isDirectory() && file.exists()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                if (this.isIgnoreFile(child) || !child.isFile()) continue;
                String text = IOHelper.readFully(child);
                if (Strings.isNotBlank(search) && !text.contains(search)) continue;
                if (first) {
                    first = false;
                } else {
                    buffer.append(",\n");
                }
                buffer.append("\"");
                buffer.append(child.getName());
                buffer.append("\": ");
                buffer.append(text);
                children.add(FileInfo.createFileInfo(rootDir, child));
            }
        }
        buffer.append("\n}");
        return buffer.toString();
    }

    protected CommitInfo doWrite(Git git, File rootDir, String branch, String path, byte[] contents, PersonIdent personIdent, String commitMessage) throws Exception {
        File file = this.getFile(rootDir, path);
        file.getParentFile().mkdirs();
        IOHelper.write(file, contents);
        String filePattern = GitFacadeSupport.getFilePattern(path);
        AddCommand add = git.add().addFilepattern(filePattern).addFilepattern(".");
        add.call();
        CommitCommand commit = git.commit().setAll(true).setAuthor(personIdent).setMessage(commitMessage);
        RevCommit revCommit = this.commitThenPush(git, branch, commit);
        return this.createCommitInfo(revCommit);
    }

    protected static String getFilePattern(String path) {
        String filePattern = path;
        if (filePattern.startsWith("/")) {
            filePattern = filePattern.substring(1);
        }
        return filePattern;
    }

    protected RevCommit commitThenPush(Git git, String branch, CommitCommand commit) throws Exception {
        RevCommit answer = commit.call();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Committed " + answer.getId() + " " + answer.getFullMessage());
        }
        if (this.isPushOnCommit()) {
            Iterable<PushResult> results = this.doPush(git);
            for (PushResult result : results) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Pushed " + result.getMessages() + " " + result.getURI() + " branch: " + branch + " updates: " + this.toString(result.getRemoteUpdates()));
            }
        }
        return answer;
    }

    protected String toString(Collection<RemoteRefUpdate> updates) {
        StringBuilder builder = new StringBuilder();
        for (RemoteRefUpdate update : updates) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(update.getMessage() + " " + update.getRemoteName() + " " + update.getNewObjectId());
        }
        return builder.toString();
    }

    public CommitInfo createCommitInfo(RevCommit entry) {
        Date date = GitFacade.getCommitDate(entry);
        String author = entry.getAuthorIdent().getName();
        boolean merge = entry.getParentCount() > 1;
        String shortMessage = entry.getShortMessage();
        String trimmedMessage = Strings.trimString(shortMessage, 78);
        String name = entry.getName();
        String commitHashText = this.getShortCommitHash(name);
        return new CommitInfo(commitHashText, name, author, date, merge, trimmedMessage, shortMessage);
    }

    protected String getShortCommitHash(String name) {
        int hashLen = this.shortCommitIdLength;
        return name.substring(0, hashLen);
    }

    protected String removeLeadingSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    protected boolean isIgnoreFile(File child) {
        return child.getName().startsWith(".");
    }

    protected File getFile(File rootDir, String path) {
        return new File(rootDir, this.removeLeadingSlash(path));
    }
}

