/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.gitective.core.Assert;
import org.gitective.core.GitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryUtils {
    protected static Collection<Ref> getRefs(Repository repository, String prefix) {
        try {
            return repository.getRefDatabase().getRefs(prefix).values();
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
    }

    public static Collection<String> getNoteRefs(Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        Collection<Ref> refs = RepositoryUtils.getRefs(repository, "refs/notes/");
        ArrayList<String> notes = new ArrayList<String>(refs.size());
        for (Ref ref : refs) {
            notes.add(ref.getName());
        }
        return notes;
    }

    public static Collection<String> getBranches(Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        ArrayList<String> branches = new ArrayList<String>();
        for (Ref ref : RepositoryUtils.getRefs(repository, "refs/heads/")) {
            branches.add(ref.getName());
        }
        for (Ref ref : RepositoryUtils.getRefs(repository, "refs/remotes/")) {
            branches.add(ref.getName());
        }
        return branches;
    }

    public static Collection<String> getTags(Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        return repository.getTags().keySet();
    }

    public static Collection<RefDiff> diffOriginRefs(Repository repository) {
        return RepositoryUtils.diffRemoteRefs(repository, "origin");
    }

    protected static boolean hasRemote(Repository repository, String remote) throws URISyntaxException {
        RemoteConfig config = new RemoteConfig(repository.getConfig(), remote);
        return !config.getURIs().isEmpty() || !config.getPushURIs().isEmpty();
    }

    public static Collection<RefDiff> diffRemoteRefs(Repository repository, String remote) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Remote"));
        }
        if (remote.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Remote"));
        }
        LsRemoteCommand lsRemote = new LsRemoteCommand(repository);
        lsRemote.setRemote(remote);
        try {
            Object remoteRefs = lsRemote.call();
            ArrayList<RefDiff> diffs = new ArrayList<RefDiff>();
            if (RepositoryUtils.hasRemote(repository, remote)) {
                String refPrefix = "refs/remotes/" + remote + "/";
                Iterator i$ = remoteRefs.iterator();
                while (i$.hasNext()) {
                    Ref localRef;
                    Ref remoteRef = (Ref)i$.next();
                    String name = remoteRef.getName();
                    if (name.startsWith("refs/heads/")) {
                        name = refPrefix + name.substring("refs/heads/".length());
                    } else if (!name.startsWith("refs/tags/")) {
                        name = refPrefix + name;
                    }
                    if ((localRef = repository.getRef(name)) != null && remoteRef.getObjectId().equals(localRef.getObjectId())) continue;
                    diffs.add(new RefDiff(localRef, remoteRef));
                }
            } else {
                Iterator i$ = remoteRefs.iterator();
                while (i$.hasNext()) {
                    Ref remoteRef = (Ref)i$.next();
                    Ref localRef = repository.getRef(remoteRef.getName());
                    if (localRef != null && remoteRef.getObjectId().equals(localRef.getObjectId())) continue;
                    diffs.add(new RefDiff(localRef, remoteRef));
                }
            }
            return diffs;
        }
        catch (Exception e) {
            throw new GitException(e, repository);
        }
    }

    public static Map<String, Set<String>> mapNamesToEmails(Collection<PersonIdent> persons) {
        if (persons == null || persons.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> namesToEmails = new HashMap<String, Set<String>>(persons.size());
        for (PersonIdent person : persons) {
            String email;
            String name = person.getName();
            if (name == null || name.length() == 0) continue;
            HashSet<String> emails = (HashSet<String>)namesToEmails.get(name);
            if (emails == null) {
                emails = new HashSet<String>(2);
                namesToEmails.put(name, emails);
            }
            if ((email = person.getEmailAddress()) == null || email.length() <= 0) continue;
            emails.add(email);
        }
        return namesToEmails;
    }

    public static Map<String, Set<String>> mapEmailsToNames(Collection<PersonIdent> persons) {
        if (persons == null || persons.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> emailsToNames = new HashMap<String, Set<String>>(persons.size());
        for (PersonIdent person : persons) {
            String name;
            String email = person.getEmailAddress();
            if (email == null || email.length() == 0) continue;
            HashSet<String> names = (HashSet<String>)emailsToNames.get(email);
            if (names == null) {
                names = new HashSet<String>(2);
                emailsToNames.put(email, names);
            }
            if ((name = person.getName()) == null || name.length() <= 0) continue;
            names.add(name);
        }
        return emailsToNames;
    }

    public static class RefDiff {
        private final Ref local;
        private final Ref remote;

        protected RefDiff(Ref local, Ref remote) {
            this.local = local;
            this.remote = remote;
        }

        public Ref getLocal() {
            return this.local;
        }

        public Ref getRemote() {
            return this.remote;
        }
    }
}

