/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.tree;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.gitective.core.filter.tree.BaseTreeFilter;
import org.gitective.core.filter.tree.ExtensionOccurrence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionOccurrenceFilter
extends BaseTreeFilter
implements Iterable<ExtensionOccurrence> {
    private final Map<String, ExtensionOccurrence> extensions = new HashMap<String, ExtensionOccurrence>();

    public int getCount(String extension) {
        if (extension == null || extension.length() == 0) {
            return 0;
        }
        ExtensionOccurrence count = this.extensions.get(extension);
        return count != null ? count.count : 0;
    }

    public String[] getExtensions() {
        return this.extensions.keySet().toArray(new String[this.extensions.size()]);
    }

    public Map<String, ExtensionOccurrence> getOccurrences() {
        return this.extensions;
    }

    @Override
    public BaseTreeFilter reset() {
        this.extensions.clear();
        return super.reset();
    }

    @Override
    public boolean include(TreeWalk walker) throws IOException {
        if (walker.isSubtree()) {
            return true;
        }
        String name = walker.getNameString();
        int extensionStart = name.lastIndexOf(46) + 1;
        if (extensionStart == 0 || extensionStart == name.length()) {
            return true;
        }
        ExtensionOccurrence occurrence = this.extensions.get(name = name.substring(extensionStart));
        if (occurrence != null) {
            ++occurrence.count;
        } else {
            this.extensions.put(name, new ExtensionOccurrence(name));
        }
        return true;
    }

    @Override
    public TreeFilter clone() {
        return new ExtensionOccurrenceFilter();
    }

    @Override
    public Iterator<ExtensionOccurrence> iterator() {
        return this.extensions.values().iterator();
    }
}

