/*
 * Decompiled with CFR 0.152.
 */
package io.heartpattern.springfox.paper.core.event;

import io.heartpattern.springfox.common.AnnotatedMethodScanner;
import io.heartpattern.springfox.paper.core.event.EventHandlerRegistrar;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import mu.KLogger;
import mu.KotlinLogging;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.MethodParameter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J(\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/heartpattern/springfox/paper/core/event/EventHandlerRegistrar;", "Lio/heartpattern/springfox/common/AnnotatedMethodScanner;", "Lorg/bukkit/event/EventHandler;", "plugin", "Lorg/bukkit/plugin/Plugin;", "(Lorg/bukkit/plugin/Plugin;)V", "logger", "Lmu/KLogger;", "postProcessAfterMethodInitialize", "", "bean", "", "beanName", "", "method", "Ljava/lang/reflect/Method;", "annotation", "postProcessBeforeMethodDestruction", "MethodListener", "core"})
public class EventHandlerRegistrar
extends AnnotatedMethodScanner<EventHandler> {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final KLogger logger;

    public EventHandlerRegistrar(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        super(Reflection.getOrCreateKotlinClass(EventHandler.class));
        this.plugin = plugin;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    public void postProcessAfterMethodInitialize(@NotNull Object bean, @NotNull String beanName, @NotNull Method method, @NotNull EventHandler annotation) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        method.setAccessible(true);
        if (method.getParameterCount() != 1) {
            this.logger.error("Cannot register EventHandler for " + method + " since it does not have exactly one parameter");
            return;
        }
        Class eventType = new MethodParameter(method, 0).withContainingClass(bean.getClass()).getParameterType();
        if (!Event.class.isAssignableFrom(eventType)) {
            this.logger.error("Cannot register EventHandler for " + method + " since it has parameter that does not extends Event");
            return;
        }
        if (eventType == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<out org.bukkit.event.Event>");
        }
        Bukkit.getPluginManager().registerEvent(eventType, (Listener)new MethodListener(beanName, method), annotation.priority(), (arg_0, arg_1) -> EventHandlerRegistrar.postProcessAfterMethodInitialize$lambda-0(eventType, method, bean, arg_0, arg_1), this.plugin, annotation.ignoreCancelled());
        this.logger.trace((Function0)new Function0<Object>(method, beanName){
            final /* synthetic */ Method $method;
            final /* synthetic */ String $beanName;
            {
                this.$method = $method;
                this.$beanName = $beanName;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Register EventHandler for " + this.$method + " in " + this.$beanName;
            }
        });
    }

    public void postProcessBeforeMethodDestruction(@NotNull Object bean, @NotNull String beanName, @NotNull Method method, @NotNull EventHandler annotation) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        HandlerList.unregisterAll((Listener)new MethodListener(beanName, method));
        this.logger.trace((Function0)new Function0<Object>(method, beanName){
            final /* synthetic */ Method $method;
            final /* synthetic */ String $beanName;
            {
                this.$method = $method;
                this.$beanName = $beanName;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Unregister EventHandler for " + this.$method + " in " + this.$beanName;
            }
        });
    }

    private static final void postProcessAfterMethodInitialize$lambda-0(Class $eventType, Method $method, Object $bean, Listener $noName_0, Event event) {
        Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
        Intrinsics.checkNotNullParameter((Object)$bean, (String)"$bean");
        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if ($eventType.isInstance(event)) {
            Object[] objectArray = new Object[]{event};
            $method.invoke($bean, objectArray);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/heartpattern/springfox/paper/core/event/EventHandlerRegistrar$MethodListener;", "Lorg/bukkit/event/Listener;", "beanName", "", "method", "Ljava/lang/reflect/Method;", "(Ljava/lang/String;Ljava/lang/reflect/Method;)V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "core"})
    private static final class MethodListener
    implements Listener {
        @NotNull
        private final String beanName;
        @NotNull
        private final Method method;

        public MethodListener(@NotNull String beanName, @NotNull Method method) {
            Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            this.beanName = beanName;
            this.method = method;
        }

        private final String component1() {
            return this.beanName;
        }

        private final Method component2() {
            return this.method;
        }

        @NotNull
        public final MethodListener copy(@NotNull String beanName, @NotNull Method method) {
            Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            return new MethodListener(beanName, method);
        }

        public static /* synthetic */ MethodListener copy$default(MethodListener methodListener, String string, Method method, int n, Object object) {
            if ((n & 1) != 0) {
                string = methodListener.beanName;
            }
            if ((n & 2) != 0) {
                method = methodListener.method;
            }
            return methodListener.copy(string, method);
        }

        @NotNull
        public String toString() {
            return "MethodListener(beanName=" + this.beanName + ", method=" + this.method + ')';
        }

        public int hashCode() {
            int result = this.beanName.hashCode();
            result = result * 31 + this.method.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MethodListener)) {
                return false;
            }
            MethodListener methodListener = (MethodListener)other;
            if (!Intrinsics.areEqual((Object)this.beanName, (Object)methodListener.beanName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.method, (Object)methodListener.method);
        }
    }
}

