/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics.hikari;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;
import io.helidon.common.LazyValue;
import io.helidon.common.config.Config;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.Metrics;
import java.util.Set;

public class DropwizardMetricsListener
implements MetricRegistryListener {
    private static final String SCOPE = "vendor";
    private static final System.Logger LOGGER = System.getLogger(DropwizardMetricsListener.class.getName());
    private final String prefix;
    private final LazyValue<MeterRegistry> registry = LazyValue.create(Metrics::globalRegistry);

    private DropwizardMetricsListener(String prefix) {
        this.prefix = prefix;
    }

    static MetricRegistryListener create(Config config) {
        return new DropwizardMetricsListener((String)config.get("name-prefix").asString().orElse((Object)"db.pool."));
    }

    public void onGaugeAdded(String name, com.codahale.metrics.Gauge<?> gauge) {
        Object value = gauge.getValue();
        if (value instanceof Number) {
            LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Gauge added: %s", name));
            com.codahale.metrics.Gauge<?> nGauge = gauge;
            this.registerGauge(name, nGauge);
        } else {
            LOGGER.log(System.Logger.Level.WARNING, () -> String.format("Cannot add gauge returning type " + value.getClass().getName() + " which does not extend Number", new Object[0]));
        }
    }

    public void onGaugeRemoved(String name) {
        LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Gauge removed: %s", name));
        ((MeterRegistry)this.registry.get()).remove(this.prefix + name, Set.of(), SCOPE);
    }

    public void onCounterAdded(String name, Counter counter) {
        LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Counter added: %s", name));
        this.registerGauge(name, counter);
    }

    public void onCounterRemoved(String name) {
        LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Counter removed: %s", name));
        ((MeterRegistry)this.registry.get()).remove(this.prefix + name, Set.of(), SCOPE);
    }

    public void onHistogramAdded(String name, Histogram histogram) {
        LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Ignoring histogram added: %s", name));
    }

    public void onHistogramRemoved(String name) {
        LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Ignoring histogram removed: %s", name));
    }

    public void onMeterAdded(String name, Meter meter) {
        LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Ignoring meter added: %s", name));
    }

    public void onMeterRemoved(String name) {
        LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Ignoring meter removed: %s", name));
    }

    public void onTimerAdded(String name, Timer timer) {
        LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Ignoring timer added: %s", name));
    }

    public void onTimerRemoved(String name) {
        LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Ignoring histogram removed: %s", name));
    }

    private Gauge registerGauge(String name, com.codahale.metrics.Gauge<? extends Number> gauge) {
        return (Gauge)((MeterRegistry)this.registry.get()).getOrCreate((Meter.Builder)((Gauge.Builder)Gauge.builder((String)(this.prefix + name), gauge, g -> ((Number)g.getValue()).doubleValue()).scope(SCOPE)));
    }

    private Gauge registerGauge(String name, Counter counter) {
        return (Gauge)((MeterRegistry)this.registry.get()).getOrCreate((Meter.Builder)((Gauge.Builder)Gauge.builder((String)(this.prefix + name), (Object)counter, Counter::getCount).scope(SCOPE)));
    }
}

