/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics.hikari;

import com.codahale.metrics.MetricRegistry;
import io.helidon.common.config.Config;
import io.helidon.dbclient.hikari.HikariMetricsRegistry;
import io.helidon.dbclient.metrics.hikari.DropwizardMetricsListener;
import java.util.function.Consumer;

final class HikariMetricsExtension
implements HikariMetricsRegistry {
    private final Config config;
    private final boolean enabled;

    private HikariMetricsExtension(Config config, boolean enabled) {
        this.config = config;
        this.enabled = enabled;
    }

    static HikariMetricsRegistry create(Config config) {
        return new HikariMetricsExtension(config, (Boolean)config.get("enabled").asBoolean().orElse((Object)true));
    }

    public void register(Consumer<Object> registry) {
        if (this.enabled) {
            MetricRegistry metricRegistry = new MetricRegistry();
            metricRegistry.addListener(DropwizardMetricsListener.create(this.config));
            registry.accept(metricRegistry);
        }
    }
}

