/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics.jdbc;

import com.codahale.metrics.MetricRegistry;
import com.zaxxer.hikari.HikariConfig;
import io.helidon.config.Config;
import io.helidon.dbclient.jdbc.HikariCpExtension;
import io.helidon.dbclient.metrics.jdbc.DropwizardMetricsListener;

final class HikariMetricsExtension
implements HikariCpExtension {
    private final Config config;
    private final boolean enabled;

    private HikariMetricsExtension(Config config, boolean enabled) {
        this.config = config;
        this.enabled = enabled;
    }

    static HikariMetricsExtension create(Config config) {
        return new HikariMetricsExtension(config, (Boolean)config.get("enabled").asBoolean().orElse((Object)true));
    }

    public void configure(HikariConfig poolConfig) {
        if (this.enabled) {
            MetricRegistry metricRegistry = new MetricRegistry();
            metricRegistry.addListener(DropwizardMetricsListener.create(this.config));
            poolConfig.setMetricRegistry((Object)metricRegistry);
        }
    }
}

