/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.MongoDatabase;
import io.helidon.common.GenericType;
import io.helidon.common.reactive.Multi;
import io.helidon.dbclient.DbInterceptorContext;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbRows;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.mongodb.MongoDbQueryProcessor;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class MongoDbCommandExecutor {
    private static final Logger LOGGER = Logger.getLogger(MongoDbCommandExecutor.class.getName());

    private MongoDbCommandExecutor() {
        throw new UnsupportedOperationException("Utility class MongoDbCommandExecutor instances are not allowed!");
    }

    static CompletionStage<DbRows<DbRow>> executeCommand(MongoDbStatement dbStatement, CompletionStage<DbInterceptorContext> dbContextFuture, CompletableFuture<Void> statementFuture, CompletableFuture<Long> commandFuture) {
        dbContextFuture.exceptionally(throwable -> {
            statementFuture.completeExceptionally((Throwable)throwable);
            commandFuture.completeExceptionally((Throwable)throwable);
            return null;
        });
        CompletionStage<MongoDbStatement.MongoStatement> mongoStmtFuture = dbContextFuture.thenApply(dbContext -> {
            MongoDbStatement.MongoStatement stmt = new MongoDbStatement.MongoStatement(DbStatementType.COMMAND, MongoDbStatement.READER_FACTORY, dbStatement.build());
            if (stmt.getOperation() == MongoDbStatement.MongoOperation.COMMAND) {
                return stmt;
            }
            throw new UnsupportedOperationException(String.format("Operation %s is not supported", stmt.getOperation().toString()));
        });
        return MongoDbCommandExecutor.executeCommandInMongoDB(dbStatement, mongoStmtFuture, statementFuture, commandFuture);
    }

    private static CompletionStage<DbRows<DbRow>> executeCommandInMongoDB(MongoDbStatement dbStatement, CompletionStage<MongoDbStatement.MongoStatement> stmtFuture, CompletableFuture<Void> statementFuture, CompletableFuture<Long> commandFuture) {
        return stmtFuture.thenApply(mongoStmt -> {
            MongoDatabase db = dbStatement.db();
            Document command = mongoStmt.getQuery();
            LOGGER.fine(() -> String.format("Command: %s", command.toString()));
            Publisher publisher = dbStatement.noTx() ? db.runCommand((Bson)command) : db.runCommand(dbStatement.txManager().tx(), (Bson)command);
            return publisher;
        }).thenApply(publisher -> new CommandRows((Publisher<Document>)publisher, dbStatement, statementFuture, commandFuture));
    }

    static final class CommandRows
    implements DbRows<DbRow> {
        private final AtomicBoolean resultRequested = new AtomicBoolean(false);
        private final Publisher<Document> publisher;
        private final MongoDbStatement dbStatement;
        private final CompletableFuture<Void> statementFuture;
        private final CompletableFuture<Long> commandFuture;

        CommandRows(Publisher<Document> publisher, MongoDbStatement dbStatement, CompletableFuture<Void> statementFuture, CompletableFuture<Long> commandFuture) {
            this.publisher = publisher;
            this.dbStatement = dbStatement;
            this.statementFuture = statementFuture;
            this.commandFuture = commandFuture;
        }

        public <U> DbRows<U> map(Function<DbRow, U> mapper) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public <U> DbRows<U> map(Class<U> type) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public <U> DbRows<U> map(GenericType<U> type) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Flow.Publisher<DbRow> publisher() {
            this.checkResult();
            return this.toDbPublisher();
        }

        public CompletionStage<List<DbRow>> collect() {
            this.checkResult();
            return Multi.from(this.toDbPublisher()).collectList().toStage();
        }

        private Flow.Publisher<DbRow> toDbPublisher() {
            MongoDbQueryProcessor qp = new MongoDbQueryProcessor(this.dbStatement, this.statementFuture, this.commandFuture);
            this.publisher.subscribe((Subscriber)qp);
            return qp;
        }

        private void checkResult() {
            if (this.resultRequested.get()) {
                throw new IllegalStateException("Result has already been requested");
            }
            this.resultRequested.set(true);
        }
    }
}

