/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.MongoDatabase;
import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbExecute;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementGeneric;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.DbStatements;
import io.helidon.dbclient.common.AbstractDbExecute;
import io.helidon.dbclient.common.InterceptorSupport;
import io.helidon.dbclient.mongodb.MongoDbStatementDml;
import io.helidon.dbclient.mongodb.MongoDbStatementGeneric;
import io.helidon.dbclient.mongodb.MongoDbStatementGet;
import io.helidon.dbclient.mongodb.MongoDbStatementQuery;

public class MongoDbExecute
extends AbstractDbExecute
implements DbExecute {
    private final DbMapperManager dbMapperManager;
    private final MapperManager mapperManager;
    private final InterceptorSupport interceptors;
    private final MongoDatabase db;

    MongoDbExecute(MongoDatabase db, DbStatements statements, DbMapperManager dbMapperManager, MapperManager mapperManager, InterceptorSupport interceptors) {
        super(statements);
        this.db = db;
        this.dbMapperManager = dbMapperManager;
        this.mapperManager = mapperManager;
        this.interceptors = interceptors;
    }

    public DbStatementQuery createNamedQuery(String statementName, String statement) {
        return new MongoDbStatementQuery(DbStatementType.QUERY, this.db, statementName, statement, this.dbMapperManager, this.mapperManager, this.interceptors);
    }

    public DbStatementGet createNamedGet(String statementName, String statement) {
        return new MongoDbStatementGet(this.db, statementName, statement, this.dbMapperManager, this.mapperManager, this.interceptors);
    }

    public DbStatementDml createNamedDmlStatement(String statementName, String statement) {
        return new MongoDbStatementDml(DbStatementType.DML, this.db, statementName, statement, this.dbMapperManager, this.mapperManager, this.interceptors);
    }

    public DbStatementDml createNamedInsert(String statementName, String statement) {
        return new MongoDbStatementDml(DbStatementType.INSERT, this.db, statementName, statement, this.dbMapperManager, this.mapperManager, this.interceptors);
    }

    public DbStatementDml createNamedUpdate(String statementName, String statement) {
        return new MongoDbStatementDml(DbStatementType.UPDATE, this.db, statementName, statement, this.dbMapperManager, this.mapperManager, this.interceptors);
    }

    public DbStatementDml createNamedDelete(String statementName, String statement) {
        return new MongoDbStatementDml(DbStatementType.DELETE, this.db, statementName, statement, this.dbMapperManager, this.mapperManager, this.interceptors);
    }

    public DbStatementGeneric createNamedStatement(String statementName, String statement) {
        return new MongoDbStatementGeneric(DbStatementType.UNKNOWN, this.db, statementName, statement, this.dbMapperManager, this.mapperManager, this.interceptors);
    }
}

