/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.MongoDatabase;
import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbInterceptorContext;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.common.InterceptorSupport;
import io.helidon.dbclient.mongodb.MongoDbDMLExecutor;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;

public class MongoDbStatementDml
extends MongoDbStatement<DbStatementDml, Long>
implements DbStatementDml {
    private static final Logger LOGGER = Logger.getLogger(MongoDbStatementDml.class.getName());
    private DbStatementType dbStatementType;
    private MongoDbStatement.MongoStatement statement;

    MongoDbStatementDml(DbStatementType dbStatementType, MongoDatabase db, String statementName, String statement, DbMapperManager dbMapperManager, MapperManager mapperManager, InterceptorSupport interceptors) {
        super(dbStatementType, db, statementName, statement, dbMapperManager, mapperManager, interceptors);
        this.dbStatementType = dbStatementType;
    }

    public CompletionStage<Long> execute() {
        this.statement = new MongoDbStatement.MongoStatement(this.dbStatementType, READER_FACTORY, this.build());
        switch (this.statement.getOperation()) {
            case INSERT: {
                this.dbStatementType = DbStatementType.INSERT;
                break;
            }
            case UPDATE: {
                this.dbStatementType = DbStatementType.UPDATE;
                break;
            }
            case DELETE: {
                this.dbStatementType = DbStatementType.DELETE;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected value for DML statement: %s", new Object[]{this.statement.getOperation()}));
            }
        }
        return super.execute();
    }

    protected CompletionStage<Long> doExecute(CompletionStage<DbInterceptorContext> dbContextFuture, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        return MongoDbDMLExecutor.executeDml(this, this.dbStatementType, this.statement, dbContextFuture, statementFuture, queryFuture);
    }

    protected DbStatementType statementType() {
        return this.dbStatementType;
    }
}

