/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.MongoDatabase;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.reactive.Single;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.common.InterceptorSupport;
import io.helidon.dbclient.mongodb.MongoDbStatementQuery;
import io.helidon.dbclient.mongodb.MongoDbTransaction;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;

public class MongoDbStatementGet
implements DbStatementGet {
    private final MongoDbStatementQuery theQuery;

    MongoDbStatementGet(MongoDatabase db, String statementName, String statement, DbMapperManager dbMapperManager, MapperManager mapperManager, InterceptorSupport interceptors) {
        this.theQuery = new MongoDbStatementQuery(DbStatementType.GET, db, statementName, statement, dbMapperManager, mapperManager, interceptors);
    }

    public MongoDbStatementGet params(List<?> parameters) {
        this.theQuery.params(parameters);
        return this;
    }

    public MongoDbStatementGet params(Map<String, ?> parameters) {
        this.theQuery.params(parameters);
        return this;
    }

    public MongoDbStatementGet namedParam(Object parameters) {
        this.theQuery.namedParam(parameters);
        return this;
    }

    public MongoDbStatementGet indexedParam(Object parameters) {
        this.theQuery.indexedParam(parameters);
        return this;
    }

    public MongoDbStatementGet addParam(Object parameter) {
        this.theQuery.addParam(parameter);
        return this;
    }

    public MongoDbStatementGet addParam(String name, Object parameter) {
        this.theQuery.addParam(name, parameter);
        return this;
    }

    public CompletionStage<Optional<DbRow>> execute() {
        return this.theQuery.execute().thenApply(dbRows -> Single.from((Flow.Publisher)dbRows.publisher())).thenCompose(Single::toOptionalStage);
    }

    MongoDbStatementGet inTransaction(MongoDbTransaction.TransactionManager tx) {
        this.theQuery.inTransaction(tx);
        return this;
    }
}

