/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.MongoDatabase;
import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbInterceptorContext;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbRows;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.common.InterceptorSupport;
import io.helidon.dbclient.mongodb.MongoDbQueryExecutor;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;

class MongoDbStatementQuery
extends MongoDbStatement<DbStatementQuery, DbRows<DbRow>>
implements DbStatementQuery {
    private static final Logger LOGGER = Logger.getLogger(MongoDbStatementQuery.class.getName());

    MongoDbStatementQuery(DbStatementType dbStatementType, MongoDatabase db, String statementName, String statement, DbMapperManager dbMapperManager, MapperManager mapperManager, InterceptorSupport interceptors) {
        super(dbStatementType, db, statementName, statement, dbMapperManager, mapperManager, interceptors);
    }

    protected CompletionStage<DbRows<DbRow>> doExecute(CompletionStage<DbInterceptorContext> dbContextFuture, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        return MongoDbQueryExecutor.executeQuery(this, dbContextFuture, statementFuture, queryFuture);
    }
}

