/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.FindPublisher;
import io.helidon.common.GenericType;
import io.helidon.common.reactive.Multi;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.common.DbClientContext;
import io.helidon.dbclient.mongodb.MongoDbQueryProcessor;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.bson.Document;
import org.reactivestreams.Subscriber;

public final class MongoDbRows<T> {
    private final AtomicBoolean resultRequested = new AtomicBoolean();
    private DbClientContext clientContext;
    private final FindPublisher<Document> documentFindPublisher;
    private final MongoDbStatement dbStatement;
    private final CompletableFuture<Long> queryFuture;
    private final GenericType<T> currentType;
    private final Function<?, T> resultMapper;
    private final MongoDbRows<?> parent;
    private final CompletableFuture<Void> statementFuture;

    MongoDbRows(DbClientContext clientContext, FindPublisher<Document> documentFindPublisher, MongoDbStatement dbStatement, Class<T> initialType, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        this.clientContext = clientContext;
        this.documentFindPublisher = documentFindPublisher;
        this.dbStatement = dbStatement;
        this.statementFuture = statementFuture;
        this.queryFuture = queryFuture;
        this.currentType = GenericType.create(initialType);
        this.resultMapper = Function.identity();
        this.parent = null;
    }

    Flow.Publisher<T> publisher() {
        this.checkResult();
        return this.toPublisher();
    }

    private Flow.Publisher<T> toPublisher() {
        if (null == this.parent) {
            return this.toDbPublisher();
        }
        Flow.Publisher<?> parentPublisher = this.parent.publisher();
        Function<?, T> mappingFunction = this.resultMapper;
        return Multi.create(parentPublisher).map(mappingFunction::apply);
    }

    private Flow.Publisher<DbRow> toDbPublisher() {
        MongoDbQueryProcessor qp = new MongoDbQueryProcessor(this.clientContext, this.dbStatement, this.statementFuture, this.queryFuture);
        this.documentFindPublisher.subscribe((Subscriber)qp);
        return qp;
    }

    private void checkResult() {
        if (this.resultRequested.get()) {
            throw new IllegalStateException("Result has already been requested");
        }
        this.resultRequested.set(true);
    }
}

