/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import io.helidon.common.config.Config;
import io.helidon.dbclient.DbClient;
import io.helidon.dbclient.DbClientBuilderBase;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.mongodb.MongoDbClient;
import io.helidon.dbclient.mongodb.MongoDbClientConfig;
import io.helidon.dbclient.spi.DbClientBuilder;

public final class MongoDbClientBuilder
extends DbClientBuilderBase<MongoDbClientBuilder>
implements DbClientBuilder<MongoDbClientBuilder> {
    private String credDb;
    private MongoDbClientConfig dbConfig;

    MongoDbClientBuilder() {
    }

    public static MongoDbClientBuilder create() {
        return new MongoDbClientBuilder();
    }

    public DbClient doBuild() {
        if (null == this.dbConfig) {
            this.dbConfig = new MongoDbClientConfig(this.url(), this.username(), this.password(), this.credDb);
        }
        return new MongoDbClient(this);
    }

    public MongoDbClientBuilder config(Config config) {
        Config connConfig = config.get("connection");
        if (!connConfig.exists()) {
            throw new DbClientException(String.format("No database connection configuration (%s) was found", connConfig.key()));
        }
        connConfig.get("url").asString().ifPresent(arg_0 -> ((MongoDbClientBuilder)this).url(arg_0));
        connConfig.get("username").asString().ifPresent(arg_0 -> ((MongoDbClientBuilder)this).username(arg_0));
        connConfig.get("password").asString().ifPresent(arg_0 -> ((MongoDbClientBuilder)this).password(arg_0));
        config.get("credDb").asString().ifPresent(this::credDb);
        return (MongoDbClientBuilder)super.config(config);
    }

    public MongoDbClientBuilder credDb(String db) {
        this.credDb = db;
        return this;
    }

    MongoDbClientConfig dbConfig() {
        return this.dbConfig;
    }
}

