<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Features and Benefits of Helidon</dt>
<dd slot="desc"><ul class="ulist">
<li>
<p><router-link to="#_open_source_with_support" @click.native="this.scrollFix('#_open_source_with_support')">Open Source with Support</router-link></p>

</li>
<li>
<p><router-link to="#_two_api_flavors_for_two_programming_styles" @click.native="this.scrollFix('#_two_api_flavors_for_two_programming_styles')">Two API Flavors for Two Programming Styles</router-link></p>

</li>
<li>
<p><router-link to="#_feature_richness" @click.native="this.scrollFix('#_feature_richness')">Feature Richness</router-link></p>

</li>
<li>
<p><router-link to="#_enterprise_features" @click.native="this.scrollFix('#_enterprise_features')">Enterprise Features</router-link></p>

</li>
<li>
<p><router-link to="#_integrations" @click.native="this.scrollFix('#_integrations')">Integrations</router-link></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_open_source_with_support">Open Source with Support</h2>
<div class="section">
<p>Helidon is open-source software, licensed with Apache License, Version 2.0. Its
codebase is kept in GitHub. Its artifacts are published to Maven Central. This
makes it easy for users to inspect, modify, and contribute to its source code. The
Apache license makes it easy for organizations to adopt Helidon from a licensing
perspective. Publishing artifacts to Maven Central makes it easy and natural for
developers and operators to pull Helidon binaries into development
environments and CI/CD pipelines. In short, Helidon is intentionally aligned with
modern mainstream development practices to make it as easy as possible to
adopt and use.</p>

<p>And yet, enterprise-grade support is also available for Helidon. Oracle offers
cost-competitive commercial support for Helidon, for customers serious about
support SLAs for their production operations. So, customers can get the best of
both worlds: seamless incorporation of Helidon into DevOps practices and third-
party product approvals, and award-winning customer support for high-scale
mission-critical production applications.</p>

</div>


<h2 id="_two_api_flavors_for_two_programming_styles">Two API Flavors for Two Programming Styles</h2>
<div class="section">
<p>Helidon offers two API flavors: Helidon SE, and Helidon MP. Both are fun to
program in, but each caters to a different style of programming</p>

</div>


<h2 id="_feature_richness">Feature Richness</h2>
<div class="section">
<p>Both API flavors, Helidon SE and Helidon MP, offer a rich and similar set of
features, like configuration and metrics and security, as examples. In Helidon
MP, the APIs for the features are specified by a standards body, whereas in
Helidon SE they are not. In both cases, the
set of features available is complete enough to cover every aspect of the needs
of modern microservices applications.</p>

</div>


<h2 id="_enterprise_features">Enterprise Features</h2>
<div class="section">
<p>Helidon intentionally includes many features required by industrial-strength
enterprise applications – even when they are now architected with microservices.
Among these features are support for data access, messaging, and transactions,
with integrations to existing Oracle products in each category.</p>

</div>


<h2 id="_integrations">Integrations</h2>
<div class="section">
<p>Helidon integrates with many other technologies that are useful in the
implementation of microservices applications, for example:</p>

<ul class="ulist">
<li>
<p>Oracle Coherence and Coherence Community Edition, the leading in-
memory data grid, which can serve as a distributed cache or system of
record for stateful microservices</p>

</li>
<li>
<p>The Oracle Cloud Infrastructure (OCI) SDK for Java, for using a wide
variety of OCI services from within Helidon applications</p>

</li>
<li>
<p>Oracle WebLogic Server (WLS), including</p>
<ul class="ulist">
<li>
<p>Bi-directional REST service invocations</p>

</li>
<li>
<p>Helidon-to-WLS SOAP web service invocations</p>

</li>
<li>
<p>Helidon consumption and production of messages on WLS-
hosted JMS destinations</p>

</li>
<li>
<p>Single sign-on between Helidon and WLS -hosted services
using Oracle Identity Cloud Service</p>

</li>
<li>
<p>Distributed transaction coordination between Helidon and WLS</p>

</li>
<li>
<p>hosted resources using Oracle MicroTx Free</p>

</li>
</ul>

</li>
<li>
<p>Messaging Connectors for JMS, Kafka, and Oracle AQ, to allow Helidon
applications to consume and produce messages with those providers</p>

</li>
<li>
<p>HashiCorp Vault for accessing securely stored tokens, passwords, API
keys, PKI certificates, and other secrets</p>

</li>
<li>
<p>Micrometer Metrics, for monitoring Helidon applications using
Micrometer</p>

</li>
<li>
<p>Neo4j, for using a graph database from within Helidon applications</p>

</li>
</ul>

</div>

</doc-view>
