<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>RevocationConfig (common.tls) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.common.tls/io/helidon/common/tls/RevocationConfig.html">io.helidon.common.tls.RevocationConfig</a></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>check-only-end-entity</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Only check the revocation status of end-entity certificates.
 Default value is <code>false</code>.</p>

<pre>@return whether to check only end-entity certificates</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Flag indicating whether this revocation config is enabled.</p>

<pre>@return enabled flag</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>fallback-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Enable fallback to the less preferred checking option.</p>

<pre>@return whether to allow fallback to the less preferred checking option</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>ocsp-responder-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The URI that identifies the location of the OCSP responder. This
 overrides the <code>ocsp.responderURL</code> security property and any
 responder specified in a certificate&#8217;s Authority Information Access
 Extension, as defined in RFC 5280.</p>

<pre>@return OCSP responder URI</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>prefer-crl-over-ocsp</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Prefer CRL over OCSP.
 Default value is <code>false</code>.</p>

<pre>@return whether to prefer CRL over OCSP</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>soft-fail-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Allow revocation check to succeed if the revocation status cannot be
 determined for one of the following reasons:</p>

<ul class="ulist">
<li>
<p>The CRL or OCSP response cannot be obtained because of a
network error.</p>

</li>
<li>
<p>The OCSP responder returns one of the following errors
specified in section 2.3 of RFC 2560: internalError or tryLater.</p>

</li>
</ul>

<p>@return whether soft fail is enabled</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
