<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>OciConfig (integrations.oci.sdk.runtime) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.integrations.oci.sdk.runtime/io/helidon/integrations/oci/sdk/runtime/OciConfig.html">io.helidon.integrations.oci.sdk.runtime.OciConfig</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>oci</code></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>auth-strategies</code></td>
<td class=""><doc-view>
<p>string[&#93; (auto, config, config-file, instance-principals, resource-principal)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The list of authentication strategies that will be attempted by
 com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider when one is
 called for. This is only used if #authStrategy() is not present.</p>

<ul class="ulist">
<li>
<p><code>auto</code> - if present in the list, or if no value
for this property exists.</p>

</li>
<li>
<p><code>config</code> - the
com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider
will be used, customized with other configuration
properties described here.</p>

</li>
<li>
<p><code>config-file</code> - the
com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider
will be used, customized with other configuration
properties described here.</p>

</li>
<li>
<p><code>instance-principals</code> - the
com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider
will be used.</p>

</li>
<li>
<p><code>resource-principal</code> - the
com.oracle.bmc.auth.ResourcePrincipalAuthenticationDetailsProvider
will be used.</p>

</li>
</ul>

<p>If there are more than one strategy descriptors defined, the
 first one that is deemed to be available/suitable will be used and all others will be ignored.</p>

<pre>@return the list of authentication strategies that will be applied, defaulting to `auto`
@see io.helidon.integrations.oci.sdk.runtime.OciAuthenticationDetailsProvider.AuthStrategy</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>auth-strategy</code></td>
<td class=""><doc-view>
<p>string (auto, config, config-file, instance-principals, resource-principal)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The singular authentication strategy to apply. This will be preferred over #authStrategies() if both are
 present.</p>

<pre>@return the singular authentication strategy to be applied</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>auth.fingerprint</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The OCI authentication fingerprint.</p>

<pre>This configuration property has an effect only when `config` is, explicitly or implicitly,
present in the value for the #authStrategies(). This is also known as #simpleConfigIsPresent().
When it is present, this property must be provided in order to set the &lt;a
href="https://docs.oracle.com/en-us/iaas/Content/API/Concepts/apisigningkey.htm"&gt;API signing key's fingerprint&lt;/a&gt;.
See {@linkplain com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider#getFingerprint()} for more details.</pre>
<pre>@return the OCI authentication fingerprint</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>auth.keyFile</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>oci_api_key.pem</code></td>
<td class=""><doc-view>
<p>The OCI authentication key file.</p>

<pre>This configuration property has an effect only when `config` is, explicitly or implicitly,
present in the value for the #authStrategies(). This is also known as #simpleConfigIsPresent().
When it is present, this property must be provided in order to set the
{@linkplain com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider#getPrivateKey()}. This file must exist in the
`user.home` directory. Alternatively, this property can be set using either #authPrivateKey() or
using #authPrivateKeyPath().</pre>
<pre>@return the OCI authentication key file</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>auth.passphrase</code></td>
<td class=""><doc-view>
<p>char[]</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The OCI authentication passphrase.</p>

<pre>This configuration property has an effect only when `config` is, explicitly or implicitly,
present in the value for the #authStrategies(). This is also known as #simpleConfigIsPresent().
When it is present, this property must be provided in order to set the
{@linkplain com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider#getPassphraseCharacters()}.</pre>
<pre>@return the OCI authentication passphrase</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>auth.private-key</code></td>
<td class=""><doc-view>
<p>char[]</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The OCI authentication private key.</p>

<pre>This configuration property has an effect only when `config` is, explicitly or implicitly,
present in the value for the #authStrategies(). This is also known as #simpleConfigIsPresent().
When it is present, this property must be provided in order to set the
{@linkplain com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider#getPrivateKey()}. Alternatively, this property
can be set using either #authKeyFile() residing in the `user.home` directory, or using
#authPrivateKeyPath().</pre>
<pre>@return the OCI authentication private key</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>auth.private-key-path</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The OCI authentication key file path.</p>

<pre>This configuration property has an effect only when `config` is, explicitly or implicitly,
present in the value for the #authStrategies(). This is also known as #simpleConfigIsPresent().
When it is present, this property must be provided in order to set the
{@linkplain com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider#getPrivateKey()}. This file path is
an alternative for using #authKeyFile() where the file must exist in the `user.home` directory.
Alternatively, this property can be set using #authPrivateKey().</pre>
<pre>@return the OCI authentication key file path</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>auth.region</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The OCI region.</p>

<pre>This configuration property has an effect only when `config` is, explicitly or implicitly,
present in the value for the #authStrategies(). This is also known as #simpleConfigIsPresent().
When it is present, either this property or com.oracle.bmc.auth.RegionProvider must be provide a value in order
to set the {@linkplain com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider#getRegion()}.</pre>
<pre>@return the OCI region</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>auth.tenant-id</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The OCI tenant id.</p>

<pre>This configuration property has an effect only when `config` is, explicitly or implicitly,
present in the value for the #authStrategies(). This is also known as #simpleConfigIsPresent().
When it is present, this property must be provided in order to set the
{@linkplain com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider#getTenantId()}.</pre>
<pre>@return the OCI tenant id</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>auth.user-id</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The OCI user id.</p>

<pre>This configuration property has an effect only when `config` is, explicitly or implicitly,
present in the value for the #authStrategies().
When it is present, this property must be provided in order to set the
{@linkplain com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider#getUserId()}.</pre>
<pre>@return the OCI user id</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>config.path</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The OCI configuration profile path.</p>

<pre>This configuration property has an effect only when `config-file` is, explicitly or implicitly,
present in the value for the #authStrategies(). This is also known as #fileConfigIsPresent().
When it is present, this property must also be present and then the
{@linkplain com.oracle.bmc.ConfigFileReader#parse(String)}
method will be passed this value. It is expected to be passed with a
valid OCI configuration file path.</pre>
<pre>@return the OCI configuration profile path</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>config.profile</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>DEFAULT</code></td>
<td class=""><doc-view>
<p>The OCI configuration/auth profile name.</p>

<pre>This configuration property has an effect only when `config-file` is, explicitly or implicitly,
present in the value for the #authStrategies(). This is also known as #fileConfigIsPresent().
When it is present, this property may also be optionally provided in order to override the default
`DEFAULT_PROFILE_NAME`.</pre>
<pre>@return the optional OCI configuration/auth profile name</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>imds.hostname</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>169.254.169.254</code></td>
<td class=""><doc-view>
<p>The OCI IMDS hostname.</p>

<pre>This configuration property is used to identify the metadata service url.</pre>
<pre>@return the OCI IMDS hostname</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>imds.timeout.milliseconds</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT0.1S</code></td>
<td class=""><doc-view>
<p>The OCI IMDS connection timeout. This is used to auto-detect availability.</p>

<pre>This configuration property is used when attempting to connect to the metadata service.</pre>
<pre>@return the OCI IMDS connection timeout
@see OciAvailability</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
