<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>MetricsConfig (metrics.api) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.metrics.api/io/helidon/metrics/api/MetricsConfig.html">io.helidon.metrics.api.MetricsConfig</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>metrics</code></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>app-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Value for the application tag to be added to each meter ID.</p>

<pre>@return application tag value</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>app-tag-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Name for the application tag to be added to each meter ID.</p>

<pre>@return application tag name</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether metrics functionality is enabled.</p>

<pre>@return if metrics are configured to be enabled</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>key-performance-indicators</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_KeyPerformanceIndicatorMetricsConfig">KeyPerformanceIndicatorMetricsConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Key performance indicator metrics settings.</p>

<pre>@return key performance indicator metrics settings</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>permit-all</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Whether to allow anybody to access the endpoint.</p>

<pre>@return whether to permit access to metrics endpoint to anybody, defaults to `true`
@see #roles()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>rest-request-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Whether automatic REST request metrics should be measured.</p>

<pre>@return true/false</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>roles</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Hints for role names the user is expected to be in.</p>

<pre>@return list of hints</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>scoping</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_ScopingConfig">ScopingConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Settings related to scoping management.</p>

<pre>@return scoping settings</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tags</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_Tag">Tag[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Global tags.</p>

<pre>@return name/value pairs for global tags</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
