<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>EvictableCache (security.providers.common) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.common/io/helidon/security/providers/common/EvictableCache.html">io.helidon.security.providers.common.EvictableCache</a></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cache-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>If the cacheEnabled is set to false, no caching will be done.
 Otherwise (default behavior) evictable caching will be used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cache-evict-delay-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>60000</code></td>
<td class=""><doc-view>
<p>Delay from the creation of the cache to first eviction</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cache-evict-period-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>300000</code></td>
<td class=""><doc-view>
<p>How often to evict records</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cache-overall-timeout-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>3600000</code></td>
<td class=""><doc-view>
<p>Configure record timeout since its creation.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cache-timeout-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>3600000</code></td>
<td class=""><doc-view>
<p>Configure record timeout since last access.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>evictor-class</code></td>
<td class=""><doc-view>
<p>Class</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure evictor to check if a record is still valid.
 This should be a fast way to check, as it is happening in a ConcurrentHashMap#forEachKey(long, Consumer).
 This is also called during all get and remove operations to only return valid records.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>100000</code></td>
<td class=""><doc-view>
<p>Configure maximal cache size.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>parallelism-threshold</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>10000</code></td>
<td class=""><doc-view>
<p>Configure parallelism threshold.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
