<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>JwtProvider (security.providers.jwt) Configuration</dt>
<dd slot="desc"><p>JWT authentication provider</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.jwt/io/helidon/security/providers/jwt/JwtProvider.html">io.helidon.security.providers.jwt.JwtProvider</a></p>

<markup
lang="text"
title="Config key"
>jwt</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.AuthenticationProvider</code></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>allow-impersonation</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to allow impersonation by explicitly overriding
 username from outbound requests using io.helidon.security.EndpointConfig#PROPERTY_OUTBOUND_ID
 property.
 By default this is not allowed and identity can only be propagated.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>allow-unsigned</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Configure support for unsigned JWT.
 If this is set to <code>true</code> any JWT that has algorithm
 set to <code>none</code> and no <code>kid</code> defined will be accepted.
 Note that this has serious security impact - if JWT can be sent
  from a third party, this allows the third party to send ANY JWT
  and it would be accpted as valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.handler</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Token handler to extract username from request.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.jwk.resource</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>JWK resource used to verify JWTs created by other parties.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.jwt-audience</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Audience expected in inbound JWTs.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.verify-signature</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Configure whether to verify signatures.
 Signatures verification is enabled by default. You can configure the provider
 not to verify signatures.</p>

<pre>&lt;b&gt;Make sure your service is properly secured on network level and only
accessible from a secure endpoint that provides the JWTs when signature verification
is disabled. If signature verification is disabled, this service will accept &lt;i&gt;ANY&lt;/i&gt; JWT&lt;/b&gt;</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authenticate</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to authenticate requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether authentication is required.
 By default, request will fail if the username cannot be extracted.
 If set to false, request will process and this provider will abstain.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>principal-type</code></td>
<td class=""><doc-view>
<p>SubjectType (USER, SERVICE)</p>

</doc-view>
</td>
<td class=""><code>USER</code></td>
<td class=""><doc-view>
<p>Principal type this provider extracts (and also propagates).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>propagate</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to propagate identity.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_OutboundConfig">OutboundConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration of outbound rules.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.jwk.resource</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>JWK resource used to sign JWTs created by us.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.jwt-issuer</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Issuer used to create new JWTs.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>use-jwt-groups</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Claim <code>groups</code> from JWT will be used to automatically add
  groups to current subject (may be used with jakarta.annotation.security.RolesAllowed annotation).</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
