<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>HttpClientConfig (webclient.api) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.webclient.api/io/helidon/webclient/api/HttpClientConfig.html">io.helidon.webclient.api.HttpClientConfig</a></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>base-uri</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Base uri used by the client in all requests.</p>

<pre>@return base uri of the client requests</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>connect-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Connect timeout.</p>

<pre>@return connect timeout
@see io.helidon.common.socket.SocketOptions#connectTimeout()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>connection-cache-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>256</code></td>
<td class=""><doc-view>
<p>Maximal size of the connection cache.
 For most HTTP protocols, we may cache connections to various endpoints for keep alive (or stream reuse in case of HTTP/2).
 This option limits the size. Setting this number lower than the "usual" number of target services will cause connections
 to be closed and reopened frequently.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>content-encoding</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_http_encoding_ContentEncodingContext">ContentEncodingContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure the listener specific io.helidon.http.encoding.ContentEncodingContext.
 This method discards all previously registered ContentEncodingContext.
 If no content encoding context is registered, default encoding context is used.</p>

<pre>@return content encoding context</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-manager</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_webclient_api_WebClientCookieManager">WebClientCookieManager</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>WebClient cookie manager.</p>

<pre>@return cookie manager to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>default-headers</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Default headers to be used in every request from configuration.</p>

<pre>@return default headers</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>follow-redirects</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to follow redirects.</p>

<pre>@return whether to follow redirects</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>keep-alive</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Determines if connection keep alive is enabled (NOT socket keep alive, but HTTP connection keep alive, to re-use
 the same connection for multiple requests).</p>

<pre>@return keep alive for this connection
@see io.helidon.common.socket.SocketOptions#socketKeepAlive()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-in-memory-entity</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>131072</code></td>
<td class=""><doc-view>
<p>If the entity is expected to be smaller that this number of bytes, it would be buffered in memory to optimize performance.
 If bigger, streaming will be used.</p>

<pre>Note that for some entity types we cannot use streaming, as they are already fully in memory (String, byte[]), for such
cases, this option is ignored. Default is 128Kb.</pre>
<pre>@return maximal number of bytes to buffer in memory for supported writers</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-redirects</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>10</code></td>
<td class=""><doc-view>
<p>Max number of followed redirects.
 This is ignored if #followRedirects() option is <code>false</code>.</p>

<pre>@return max number of followed redirects</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>media-context</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_http_media_MediaContext">MediaContext</router-link></p>

</doc-view>
</td>
<td class=""><code>create()</code></td>
<td class=""><doc-view>
<p>Configure the listener specific io.helidon.http.media.MediaContext.
 This method discards all previously registered MediaContext.
 If no media context is registered, default media context is used.</p>

<pre>@return media context</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>media-type-parser-mode</code></td>
<td class=""><doc-view>
<p>ParserMode (STRICT, RELAXED)</p>

</doc-view>
</td>
<td class=""><code>STRICT</code></td>
<td class=""><doc-view>
<p>Configure media type parsing mode for HTTP <code>Content-Type</code> header.</p>

<pre>@return media type parsing mode</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>properties</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Properties configured for this client. These properties are propagated through client request, to be used by
 services (and possibly for other purposes).</p>

<pre>@return map of client properties</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_webclient_api_Proxy">Proxy</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Proxy configuration to be used for requests.</p>

<pre>@return proxy to use, defaults to Proxy#noProxy()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>read-continue-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT1S</code></td>
<td class=""><doc-view>
<p>Socket 100-Continue read timeout. Default is 1 second.
 This read timeout is used when 100-Continue is sent by the client, before it sends an entity.</p>

<pre>@return read 100-Continue timeout duration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>read-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Read timeout.</p>

<pre>@return read timeout
@see io.helidon.common.socket.SocketOptions#readTimeout()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>relative-uris</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Can be set to <code>true</code> to force the use of relative URIs in all requests,
 regardless of the presence or absence of proxies or no-proxy lists.</p>

<pre>@return relative URIs flag</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>send-expect-continue</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether Expect-100-Continue header is sent to verify server availability before sending an entity.</p>

<pre>Defaults to `true`.</pre>
<pre>@return whether Expect:100-Continue header should be sent on streamed transfers</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>services</code></td>
<td class=""><doc-view>
<p>io.helidon.webclient.spi.WebClientService[&#93; (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>WebClient services.</p>

<pre>@return services to use with this web client</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>share-connection-cache</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to share connection cache between all the WebClient instances in JVM.</p>

<pre>@return true if connection cache is shared</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>socket-options</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_socket_SocketOptions">SocketOptions</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Socket options for connections opened by this client.
 If there is a value explicitly configured on this type and on the socket options,
 the one configured on this type&#8217;s builder will win:</p>

<ul class="ulist">
<li>
<p>#readTimeout()</p>

</li>
<li>
<p>#connectTimeout()</p>

</li>
</ul>

<p>@return socket options</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tls</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_tls_Tls">Tls</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>TLS configuration for any TLS request from this client.
 TLS can also be configured per request.
 TLS is used when the protocol is set to <code>https</code>.</p>

<pre>@return TLS configuration to use</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
