<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Http2ClientProtocolConfig (webclient.http2) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.webclient.http2/io/helidon/webclient/http2/Http2ClientProtocolConfig.html">io.helidon.webclient.http2.Http2ClientProtocolConfig</a></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>flow-control-block-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT0.1S</code></td>
<td class=""><doc-view>
<p>Timeout for blocking between windows size check iterations.</p>

<pre>@return timeout</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>initial-window-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>65535</code></td>
<td class=""><doc-view>
<p>Configure INITIAL_WINDOW_SIZE setting for new HTTP/2 connections.
 Sends to the server the size of the largest frame payload client is willing to receive.
 Defaults to <code>io.helidon.http.http2.WindowSize#DEFAULT_WIN_SIZE</code>.</p>

<pre>@return units of octets</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-frame-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>16384</code></td>
<td class=""><doc-view>
<p>Configure initial MAX_FRAME_SIZE setting for new HTTP/2 connections.
 Maximum size of data frames in bytes the client is prepared to accept from the server.
 Default value is 2^14(16_384).</p>

<pre>@return data frame size in bytes between 2^14(16_384) and 2^24-1(16_777_215)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-header-list-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>-1</code></td>
<td class=""><doc-view>
<p>Configure initial MAX_HEADER_LIST_SIZE setting for new HTTP/2 connections.
 Sends to the server the maximum header field section size client is prepared to accept.
 Defaults to <code>-1</code>, which means "unconfigured".</p>

<pre>@return units of octets</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>h2</code></td>
<td class=""><doc-view>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>ping</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Check healthiness of cached connections with HTTP/2.0 ping frame.
 Defaults to <code>false</code>.</p>

<pre>@return use ping if true</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>ping-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT0.5S</code></td>
<td class=""><doc-view>
<p>Timeout for ping probe used for checking healthiness of cached connections.
 Defaults to <code>PT0.5S</code>, which means 500 milliseconds.</p>

<pre>@return timeout</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>prior-knowledge</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Prior knowledge of HTTP/2 capabilities of the server. If server we are connecting to does not
 support HTTP/2 and prior knowledge is set to <code>false</code>, only features supported by HTTP/1 will be available
 and attempts to use HTTP/2 specific will throw an UnsupportedOperationException.
 &lt;h4&gt;Plain text connection&lt;/h4&gt;
 If prior knowledge is set to <code>true</code>, we will not attempt an upgrade of connection and use prior knowledge.
 If prior knowledge is set to <code>false</code>, we will initiate an HTTP/1 connection and upgrade it to HTTP/2,
 if supported by the server.
 plaintext connection (<code>h2c</code>).
 &lt;h4&gt;TLS protected connection&lt;/h4&gt;
 If prior knowledge is set to <code>true</code>, we will negotiate protocol using HTTP/2 only, failing if not supported.
 if prior knowledge is set to <code>false</code>, we will negotiate protocol using both HTTP/2 and HTTP/1, using the protocol
 supported by server.</p>

<pre>@return whether to use prior knowledge of HTTP/2</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
