<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>AccessLogFeature (webserver.accesslog) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.accesslog/io/helidon/webserver/accesslog/AccessLogFeature.html">io.helidon.webserver.accesslog.AccessLogFeature</a></p>

<markup
lang="text"
title="Config key"
>access-log</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.spi.ServerFeatureProvider</code></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether this feature will be enabled.</p>

<pre>@return whether enabled</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>format</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The format for log entries (similar to the Apache <code>LogFormat</code>).
 &lt;table class="config"&gt;
     &lt;caption&gt;Log format elements&lt;/caption&gt;
     &lt;tr&gt;
         &lt;td&gt;%h&lt;/td&gt;
         &lt;td&gt;IP address of the remote host&lt;/td&gt;
         &lt;td&gt;HostLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%l&lt;/td&gt;
         &lt;td&gt;The client identity. This is always undefined in Helidon.&lt;/td&gt;
         &lt;td&gt;UserIdLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%u&lt;/td&gt;
         &lt;td&gt;User ID as asserted by Helidon Security.&lt;/td&gt;
         &lt;td&gt;UserLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%t&lt;/td&gt;
         &lt;td&gt;The timestamp&lt;/td&gt;
         &lt;td&gt;TimestampLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%r&lt;/td&gt;
         &lt;td&gt;The request line (<code>"GET /favicon.ico HTTP/1.0"</code>)&lt;/td&gt;
         &lt;td&gt;RequestLineLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%s&lt;/td&gt;
         &lt;td&gt;The status code returned to the client&lt;/td&gt;
         &lt;td&gt;StatusLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%b&lt;/td&gt;
         &lt;td&gt;The entity size in bytes&lt;/td&gt;
         &lt;td&gt;SizeLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%D&lt;/td&gt;
         &lt;td&gt;The time taken in microseconds (start of request until last byte written)&lt;/td&gt;
         &lt;td&gt;TimeTakenLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%T&lt;/td&gt;
         &lt;td&gt;The time taken in seconds (start of request until last byte written), integer&lt;/td&gt;
         &lt;td&gt;TimeTakenLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%{header-name}i&lt;/td&gt;
         &lt;td&gt;Value of header <code>header-name</code>&lt;/td&gt;
         &lt;td&gt;HeaderLogEntry&lt;/td&gt;
     &lt;/tr&gt;
 &lt;/table&gt;</p>

<pre>@return format string, such as `%h %l %u %t %r %b %{Referer`i}</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>logger-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>io.helidon.webserver.AccessLog</code></td>
<td class=""><doc-view>
<p>Name of the logger used to obtain access log logger from System#getLogger(String).
 Defaults to <code>AccessLogFeature#DEFAULT_LOGGER_NAME</code>.</p>

<pre>@return name of the logger to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>List of sockets to register this feature on. If empty, it would get registered on all sockets.
 The logger used will have the expected logger with a suffix of the socket name.</p>

<pre>@return socket names to register on, defaults to empty (all available sockets)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>weight</code></td>
<td class=""><doc-view>
<p>double</p>

</doc-view>
</td>
<td class=""><code>1000.0</code></td>
<td class=""><doc-view>
<p>Weight of the access log feature. We need to log access for anything happening on the server, so weight is high:
 <code>io.helidon.webserver.accesslog.AccessLogFeature#WEIGHT</code>.</p>

<pre>@return weight of the feature</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
