<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>ObserveFeature (webserver.observe) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.observe/io/helidon/webserver/observe/ObserveFeature.html">io.helidon.webserver.observe.ObserveFeature</a></p>

<markup
lang="text"
title="Config key"
>observe</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.spi.ServerFeatureProvider</code></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cors</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_cors_CrossOriginConfig">CrossOriginConfig</router-link></p>

</doc-view>
</td>
<td class=""><code>@io.helidon.cors.CrossOriginConfig@.create()</code></td>
<td class=""><doc-view>
<p>Cors support inherited by each observe provider, unless explicitly configured.</p>

<pre>@return cors support to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether the observe support is enabled.</p>

<pre>@return `false` to disable observe feature</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>endpoint</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>/observe</code></td>
<td class=""><doc-view>
<p>Root endpoint to use for observe providers. By default, all observe endpoint are under this root endpoint.</p>

<pre>Example:
&lt;br&gt;
If root endpoint is `/observe` (the default), and default health endpoint is `health` (relative),
health endpoint would be `/observe/health`.</pre>
<pre>@return endpoint to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>observers</code></td>
<td class=""><doc-view>
<p>io.helidon.webserver.observe.spi.Observer[&#93; (service provider interface)</p>

<p>Such as:</p>

<ul class="ulist">
<li>
<p><router-link to="/config/io_helidon_webserver_observe_config_ConfigObserver">ConfigObserver</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_observe_info_InfoObserver">InfoObserver</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_observe_log_LogObserver">LogObserver</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_observe_tracing_TracingObserver">TracingObserver</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_observe_metrics_MetricsObserver">metrics (MetricsObserver)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_observe_health_HealthObserver">health (HealthObserver)</router-link></p>

</li>
</ul>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Observers to use with this observe features.
 Each observer type is registered only once, unless it uses a custom name (default name is the same as the type).</p>

<pre>@return list of observers to use in this feature</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sockets the observability endpoint should be exposed on. If not defined, defaults to the default socket
 (<code>io.helidon.webserver.WebServer#DEFAULT_SOCKET_NAME</code>.
 Each observer may have its own configuration of sockets that are relevant to it, this only controls the endpoints!</p>

<pre>@return list of sockets to register observe endpoint on</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>weight</code></td>
<td class=""><doc-view>
<p>double</p>

</doc-view>
</td>
<td class=""><code>80.0</code></td>
<td class=""><doc-view>
<p>Change the weight of this feature. This may change the order of registration of this feature.
 By default, observability weight is <code>ObserveFeature#WEIGHT</code> so it is registered after routing.</p>

<pre>@return weight to use</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
