<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon MP Health Check Guide</dt>
<dd slot="desc"><p>This guide describes how to create a sample MicroProfile (MP) project
that can be used to run some basic examples using both built-in and custom health checks with Helidon MP.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_what_you_need">What You Need</h2>
<div class="section">
<p>For this 15 minute tutorial, you will need the following:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">A Helidon MP Application</td>
<td class="">You can use your own application or use the
 <router-link to="/mp/guides/quickstart">Helidon MP Quickstart</router-link> to create a sample application.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;21</a> (<a target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;21</a>)</td>
<td class="">Helidon requires Java 21+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.8+</a></td>
<td class="">Helidon requires Maven 3.8+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/kubernetes">install one on your desktop</router-link>.</td>
</tr>
</tbody>
</table>
</div>

<markup
lang="bash"
title="Verify Prerequisites"
>java -version
mvn --version
docker --version
kubectl version --short</markup>

<markup
lang="bash"
title="Setting JAVA_HOME"
># On Mac
export JAVA_HOME=`/usr/libexec/java_home -v 21`

# On Linux
# Use the appropriate path to your JDK
export JAVA_HOME=/usr/lib/jvm/jdk-21</markup>


<h3 id="_create_a_sample_mp_project">Create a Sample MP Project</h3>
<div class="section">
<p>Generate the project sources using the Helidon MP Maven archetype.
The result is a simple project that can be used for the examples in this guide.</p>

<markup
lang="bash"
title="Run the Maven archetype:"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-mp \
    -DarchetypeVersion=4.0.12 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-mp \
    -Dpackage=io.helidon.examples.quickstart.mp</markup>

</div>


<h3 id="_using_the_built_in_health_checks">Using the Built-In Health Checks</h3>
<div class="section">
<p>Helidon has a set of built-in health checks:</p>

<ul class="ulist">
<li>
<p>deadlock detection</p>

</li>
<li>
<p>available disk space</p>

</li>
<li>
<p>available heap memory</p>

</li>
</ul>

<p>The following example will demonstrate how to use the built-in health checks.  These examples are all executed
from the root directory of your project (helidon-quickstart-mp).</p>

<markup
lang="xml"
title="Include dependency for the built-in health checks"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.health&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-health-checks&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<markup
lang="bash"
title="Build the application then run it:"
>mvn package
java -jar target/helidon-quickstart-mp.jar</markup>

<markup
lang="bash"
title="Verify the health endpoint in a new terminal window:"
>curl http://localhost:8080/health</markup>

<markup
lang="json"
title="JSON response:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "deadlock",
      "status": "UP"
    },
    {
      "name": "diskSpace",
      "status": "UP",
      "data": {
        "free": "325.54 GB",
        "freeBytes": 349543358464,
        "percentFree": "69.91%",
        "total": "465.63 GB",
        "totalBytes": 499963174912
      }
    },
    {
      "name": "heapMemory",
      "status": "UP",
      "data": {
        "free": "230.87 MB",
        "freeBytes": 242085696,
        "max": "3.56 GB",
        "maxBytes": 3817865216,
        "percentFree": "98.90%",
        "total": "271.00 MB",
        "totalBytes": 284164096
      }
    }
  ]
}</markup>

</div>


<h3 id="_custom_liveness_health_checks">Custom Liveness Health Checks</h3>
<div class="section">
<p>You can create application-specific custom health checks and integrate them with Helidon
using CDI.  The following example shows how to add a custom liveness health check.</p>

<markup
lang="java"
title="Create a new <code>GreetLivenessCheck</code> class with the following content:"
>@Liveness <span class="conum" data-value="1" />
@ApplicationScoped <span class="conum" data-value="2" />
public class GreetLivenessCheck implements HealthCheck {

    @Override
    public HealthCheckResponse call() {
        return HealthCheckResponse.named("LivenessCheck")  <span class="conum" data-value="3" />
                .up()
                .withData("time", System.currentTimeMillis())
                .build();
    }
}</markup>

<ul class="colist">
<li data-value="1">Annotation indicating this is a liveness health check.</li>
<li data-value="2">Annotation indicating there is a single liveness <code>HealthCheck</code> object during the lifetime of the application.</li>
<li data-value="3">Build the HealthCheckResponse with status <code>UP</code> and the current time.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then verify the custom liveness health endpoint"
>curl http://localhost:8080/health/live</markup>

<markup
lang="json"
title="JSON response:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "LivenessCheck",
      "status": "UP",
      "data": {
        "time": 1566338255331
      }
    }
  ]
}</markup>

</div>


<h3 id="_custom_readiness_health_checks">Custom Readiness Health Checks</h3>
<div class="section">
<p>You can add a readiness check to indicate that the application is ready to be used.  In this
example, the server will wait five seconds before it becomes ready.</p>

<markup
lang="java"
title="Create a new <code>GreetReadinessCheck</code> class with the following content:"
>@Readiness <span class="conum" data-value="1" />
@ApplicationScoped
public class GreetReadinessCheck implements HealthCheck {
    private final AtomicLong readyTime = new AtomicLong(0);

    @Override
    public HealthCheckResponse call() {
        return HealthCheckResponse.named("ReadinessCheck")  <span class="conum" data-value="2" />
                .status(isReady())
                .withData("time", readyTime.get())
                .build();
    }

    public void onStartUp(
            @Observes @Initialized(ApplicationScoped.class) Object init) {
        readyTime.set(System.currentTimeMillis()); <span class="conum" data-value="3" />
    }

    /**
     * Become ready after 5 seconds
     *
     * @return true if application ready
     */
    private boolean isReady() {
        return Duration.ofMillis(System.currentTimeMillis() - readyTime.get()).getSeconds() &gt;= 5;
    }
}</markup>

<ul class="colist">
<li data-value="1">Annotation indicating that this is a readiness health check.</li>
<li data-value="2">Build the <code>HealthCheckResponse</code> with status <code>UP</code> after five seconds, else <code>DOWN</code>.</li>
<li data-value="3">Record the time at startup.</li>
</ul>

<markup
lang="bash"
title="Build and run the application.  Issue the curl command with -v within five seconds, and you will see that the application is not ready:"
>curl -v  http://localhost:8080/health/ready</markup>

<markup
lang="listing"
title="HTTP response status"
>&lt; HTTP/1.1 503 Service Unavailable <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The HTTP status is <code>503</code> since the application is not ready.</li>
</ul>

<markup
lang="json"
title="Response body"
>{
  "status": "DOWN",
  "checks": [
    {
      "name": "ReadinessCheck",
      "status": "DOWN",
      "data": {
        "time": 1566399775700
      }
    }
  ]
}</markup>

<markup
lang="bash"
title="After five seconds you will see the application is ready:"
>curl -v http://localhost:8080/health/ready</markup>

<markup
lang="listing"
title="HTTP response status"
>&lt; HTTP/1.1 200 OK <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The HTTP status is <code>200</code> indicating that the application is ready.</li>
</ul>

<markup
lang="json"
title="Response body"
>{
  "status": "UP",
  "checks": [
    {
      "name": "ReadinessCheck",
      "status": "UP",
      "data": {
        "time": 1566399775700
      }
    }
  ]
}</markup>

</div>


<h3 id="_custom_startup_health_checks">Custom Startup Health Checks</h3>
<div class="section">
<p>You can add a startup check to indicate if the application is initialized to the point that the other health checks make sense.
In this example, the server will wait eight seconds before it declares itself started.</p>

<markup
lang="java"
title="Create a new <code>GreetStartedCheck</code> class with the following content:"
>@Startup <span class="conum" data-value="1" />
@ApplicationScoped
public class GreetStartedCheck implements HealthCheck {
    private final AtomicLong readyTime = new AtomicLong(0);

    @Override
    public HealthCheckResponse call() {
        return HealthCheckResponse.named("StartedCheck")  <span class="conum" data-value="2" />
                .status(isStarted())
                .withData("time", readyTime.get())
                .build();
    }

    public void onStartUp(
            @Observes @Initialized(ApplicationScoped.class) Object init) {
        readyTime.set(System.currentTimeMillis()); <span class="conum" data-value="3" />
    }

    /**
     * Become ready after 5 seconds
     *
     * @return true if application ready
     */
    private boolean isStarted() {
        return Duration.ofMillis(System.currentTimeMillis() - readyTime.get()).getSeconds() &gt;= 8;
    }
}</markup>

<ul class="colist">
<li data-value="1">Annotation indicating that this is a startup health check.</li>
<li data-value="2">Build the <code>HealthCheckResponse</code> with status <code>UP</code> after eight seconds, else <code>DOWN</code>.</li>
<li data-value="3">Record the time at startup of Helidon; the application will declare itself as started eight seconds later.</li>
</ul>

<markup
lang="bash"
title="Build and run the application.  Issue the curl command with -v within five seconds, and you will see that the application has not yet started:"
>curl -v  http://localhost:8080/health/started</markup>

<markup
lang="listing"
title="HTTP response status"
>&lt; HTTP/1.1 503 Service Unavailable <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The HTTP status is <code>503</code> since the application has not started.</li>
</ul>

<markup
lang="json"
title="Response body"
>{
  "status": "DOWN",
  "checks": [
    {
      "name": "StartedCheck",
      "status": "DOWN",
      "data": {
        "time": 1566399775700
      }
    }
  ]
}</markup>

<markup
lang="bash"
title="After eight seconds you will see the application has started:"
>curl -v http://localhost:8080/health/started</markup>

<markup
lang="listing"
title="HTTP response status"
>&lt; HTTP/1.1 200 OK <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The HTTP status is <code>200</code> indicating that the application is started.</li>
</ul>

<markup
lang="json"
title="Response body"
>{
  "status": "UP",
  "checks": [
    {
      "name": "StartedCheck",
      "status": "UP",
      "data": {
        "time": 1566399775700
      }
    }
  ]
}</markup>

<p>When using the health check URLs, you can get the following health check data:</p>

<ul class="ulist">
<li>
<p>liveness only - <a target="_blank" href="http://localhost:8080/health/live" class="bare">http://localhost:8080/health/live</a></p>

</li>
<li>
<p>readiness only -  <a target="_blank" href="http://localhost:8080/health/ready" class="bare">http://localhost:8080/health/ready</a></p>

</li>
<li>
<p>startup checks only - <a target="_blank" href="http://localhost:8080/health/started" class="bare">http://localhost:8080/health/started</a></p>

</li>
<li>
<p>all health check data -  <a target="_blank" href="http://localhost:8080/health" class="bare">http://localhost:8080/health</a></p>

</li>
</ul>

<markup
lang="bash"
title="Get all the health check data, including custom data:"
>curl http://localhost:8080/health</markup>

<markup
lang="json"
title="JSON response:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "LivenessCheck",
      "status": "UP",
      "data": {
        "time": 1566403431536
      }
    },
    {
      "name": "ReadinessCheck",
      "status": "UP",
      "data": {
        "time": 1566403280639
      }
    },
    {
      "name": "StartedCheck",
      "status": "UP",
      "data": {
        "time": 1566403280639
      }
    },
    {
      "name": "deadlock",
      "state": "UP",
      "status": "UP"
    },
    {
      "name": "diskSpace",
      "state": "UP",
      "status": "UP",
      "data": {
        "free": "325.50 GB",
        "freeBytes": 349500698624,
        "percentFree": "69.91%",
        "total": "465.63 GB",
        "totalBytes": 499963174912
      }
    },
    {
      "name": "heapMemory",
      "state": "UP",
      "status": "UP",
      "data": {
        "free": "231.01 MB",
        "freeBytes": 242235928,
        "max": "3.56 GB",
        "maxBytes": 3817865216,
        "percentFree": "98.79%",
        "total": "275.00 MB",
        "totalBytes": 288358400
      }
    }
  ]
}</markup>

</div>


<h3 id="_custom_health_root_path_and_port">Custom Health Root Path and Port</h3>
<div class="section">
<p>You can specify a custom port and root context for the root health endpoint path.
However, you cannot use different ports, such as <a target="_blank" href="http://localhost:8080/myhealth" class="bare">http://localhost:8080/myhealth</a> and <a target="_blank" href="http://localhost:8081/myhealth/live" class="bare">http://localhost:8081/myhealth/live</a>.
Likewise, you cannot use different paths, such as <a target="_blank" href="http://localhost:8080/health" class="bare">http://localhost:8080/health</a> and <a target="_blank" href="http://localhost:8080/probe/live" class="bare">http://localhost:8080/probe/live</a>.</p>

<p>The example below will change the root path.</p>

<markup
lang="yaml"
title="Create a file named <code>application.yaml</code> in the <code>resources</code> directory with the following contents:"
>health:
  endpoint: "/myhealth" <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The <code>endpoint</code> settings specifies the root path for the health endpoint.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then verify that the health endpoint is using the new <code>/myhealth</code> root:"
>curl http://localhost:8080/myhealth
curl http://localhost:8080/myhealth/live
curl http://localhost:8080/myhealth/ready
curl http://localhost:8080/myhealth/started</markup>

<p>The following example will change the root path and the health port.</p>

<markup
lang="yaml"
title="Update application.yaml to use a different port and root path for the health endpoint:"
>server:
  port: 8080 <span class="conum" data-value="1" />
  sockets:
    - name: "admin" <span class="conum" data-value="2" />
      port: 8081 <span class="conum" data-value="3" />
  features:
    observe:
      sockets: "admin" <span class="conum" data-value="4" />
health:
  endpoint: "/myhealth" <span class="conum" data-value="5" /></markup>

<ul class="colist">
<li data-value="1">The default port for the application.</li>
<li data-value="2">The name of the new socket, it can be any name, this example uses <code>admin</code>.</li>
<li data-value="3">The port for the <code>admin</code> socket.</li>
<li data-value="4">The health endpoint, as part of Helidon&#8217;s observability support, uses the socket <code>admin</code>.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then verify the health endpoint using port <code>8081</code> and <code>/myhealth</code>:"
>curl http://localhost:8081/myhealth
curl http://localhost:8081/myhealth/live
curl http://localhost:8081/myhealth/ready
curl http://localhost:8081/myhealth/started</markup>

</div>


<h3 id="_using_liveness_readiness_and_startup_health_checks_with_kubernetes">Using Liveness, Readiness, and Startup Health Checks with Kubernetes</h3>
<div class="section">
<p>The following example shows how to integrate the Helidon health check API with an application that implements
health endpoints for the Kubernetes liveness, readiness, and startup probes.</p>

<p><strong>Delete the contents of <code>application.yaml</code> so that the default health endpoint path and port are used.</strong></p>

<markup
lang="bash"
title="Rebuild and start the application, then verify the health endpoint:"
>curl http://localhost:8080/health</markup>

<markup
lang="bash"
title="Stop the application and build the docker image:"
>docker build -t helidon-quickstart-mp .</markup>

<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>health.yaml</code>, with the following content:"
>kind: Service
apiVersion: v1
metadata:
  name: helidon-health <span class="conum" data-value="1" />
  labels:
    app: helidon-health
spec:
  type: NodePort
  selector:
    app: helidon-health
  ports:
    - port: 8080
      targetPort: 8080
      name: http
---
kind: Deployment
apiVersion: apps/v1
metadata:
  name: helidon-health <span class="conum" data-value="2" />
spec:
  replicas: 1
  selector:
    matchLabels:
      app: helidon-health
  template:
    metadata:
      labels:
        app: helidon-health
        version: v1
    spec:
      containers:
        - name: helidon-health
          image: helidon-quickstart-mp
          imagePullPolicy: IfNotPresent
          ports:
            - containerPort: 8080
          livenessProbe:
            httpGet:
              path: /health/live <span class="conum" data-value="3" />
              port: 8080
            initialDelaySeconds: 5 <span class="conum" data-value="4" />
            periodSeconds: 10
            timeoutSeconds: 3
            failureThreshold: 3
          readinessProbe:
            httpGet:
              path: /health/ready <span class="conum" data-value="5" />
              port: 8080
            initialDelaySeconds: 5 <span class="conum" data-value="6" />
            periodSeconds: 2
            timeoutSeconds: 3
          startupProbe:
            httpGet:
              path: /health/started <span class="conum" data-value="7" />
              port: 8080
            initialDelaySeconds: 8 <span class="conum" data-value="8" />
            periodSeconds: 10
            timeoutSeconds: 3
            failureThreshold: 3
---</markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>8080</code>.</li>
<li data-value="2">A deployment with one replica of a pod.</li>
<li data-value="3">The HTTP endpoint for the liveness probe.</li>
<li data-value="4">The liveness probe configuration.</li>
<li data-value="5">The HTTP endpoint for the readiness probe.</li>
<li data-value="6">The readiness probe configuration.</li>
<li data-value="7">The HTTP endpoint for the startup probe.</li>
<li data-value="8">The startup probe configuration.</li>
</ul>

<markup
lang="bash"
title="Create and deploy the application into Kubernetes:"
>kubectl apply -f ./health.yaml</markup>

<markup
lang="bash"
title="Get the service information:"
>kubectl get service/helidon-health</markup>

<markup
lang="bash"

>NAME             TYPE       CLUSTER-IP      EXTERNAL-IP   PORT(S)          AGE
helidon-health   NodePort   10.107.226.62   &lt;none&gt;        8080:30116/TCP   4s <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>30116</code>.</li>
</ul>

<markup
lang="bash"
title="Verify the health endpoints using port '30116', your port may be different. The JSON response will be the same as your previous test:"
>curl http://localhost:30116/health</markup>

<markup
lang="bash"
title="Delete the application, cleaning up Kubernetes resources:"
>kubectl delete -f ./health.yaml</markup>

</div>


<h3 id="_summary">Summary</h3>
<div class="section">
<p>This guide demonstrated how to use health checks in a Helidon MP application as follows:</p>

<ul class="ulist">
<li>
<p>Access the default health checks</p>

</li>
<li>
<p>Create and use custom readiness, liveness, and startup checks</p>

</li>
<li>
<p>Customize the health check root path and port</p>

</li>
<li>
<p>Integrate Helidon health check API with Kubernetes</p>

</li>
</ul>

<p>Refer to the following references for additional information:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-health-4.0/microprofile-health-spec-4.0.html">MicroProfile health check specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-health-4.0/apidocs">MicroProfile health check Javadoc</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/index.html?overview-summary.html">Helidon Javadoc</a></p>

</li>
</ul>

</div>

</div>

</doc-view>
