<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon provides built-in test support for Helidon testing with JUnit 5.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Helidon Testing Framework
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
     &lt;groupId&gt;io.helidon.webserver.testing.junit5&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-webserver-testing-junit5&lt;/artifactId&gt;
     &lt;scope&gt;test&lt;/scope&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Helidon provides a rich set of extensions based on JUnit 5 for Helidon WebServer testing. Testing can be done with automatic server start-up, configuration, and shutdown. Testing can also be done without full server start-up with <code>DirectClient</code> when no real sockets are created.</p>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>There are two main annotations that you can use to test Helidon WebServer.</p>

<ul class="ulist">
<li>
<p><code>@ServerTest</code> is an integration test annotation that starts the server (opens ports) and provides client injection pre-configured for the server port(s).</p>

</li>
<li>
<p><code>@RoutingTest</code> is a unit test annotation that does not start the server and does not open ports but provides a direct client (with the same API as the usual network client) to test routing.</p>

</li>
</ul>

<p>The additional annotation <code>@Socket</code> can be used to qualify the injection of parameters into test constructors or methods, such as to obtain a client configured for the named socket.</p>

<p>The following table lists the supported types of parameters for the <code>@SetUpRoute</code> annotated methods. Such methods MUST be static
and may have any name. The <code>@SetUpRoute</code> annotation has <code>value</code> with socket name (to customize the setup for a different socket).</p>

<ul class="ulist">
<li>
<p>Parameter type - supported class of a parameter</p>

</li>
<li>
<p>Annotation - which annotations support this parameter</p>

</li>
<li>
<p>Modules - which webserver extension modules support this signature</p>

</li>
</ul>

<div class="block-title"><span>Parameters for the <code>@SetUpRoute</code> annotated methods.</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 25%;">
<col style="width: 25%;">
<col style="width: 25%;">
<col style="width: 25%;">
</colgroup>
<thead>
<tr>
<th>Parameter Type</th>
<th>Annotation</th>
<th>Modules</th>
<th>Notes</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>HttpRouting.Builder</code></td>
<td class=""><code>@ServerTest</code>, <code>@RoutingTest</code></td>


</tr>
<tr>
<td class=""><code>HttpRules</code></td>
<td class=""><code>@ServerTest</code>, <code>@RoutingTest</code></td>

<td class="">Same as <code>HttpRouting.Builder</code>, only routing setup</td>
</tr>
<tr>
<td class=""><code>Router.RouterBuilder&lt;?&gt;</code></td>
<td class=""><code>@ServerTest</code>, <code>@RoutingTest</code></td>


</tr>
<tr>
<td class=""><code>SocketListener.Builder</code></td>
<td class=""><code>@ServerTest</code></td>


</tr>
<tr>
<td class=""><code>WebSocketRouting.Builder</code></td>
<td class=""><code>@ServerTest</code>, <code>@RoutingTest</code></td>
<td class="">websocket</td>

</tr>
</tbody>
</table>
</div>

<p>In addition, a static method annotated with <code>@SetUpServer</code> can be defined for <code>@ServerTest</code>, which has a single parameter of <a target="_blank" href="/apidocs/io.helidon.webserver/io/helidon/webserver/WebServerConfig.Builder.html"><code>WebServerConfig.Builder</code></a>.</p>

<p>The following table lists the injectable types (through constructor or method injection).</p>

<ul class="ulist">
<li>
<p>Type - type that can be injected</p>

</li>
<li>
<p>Socket - if checked, you can use the <code>@Socket</code> annotation to obtain a value specific to that named socket</p>

</li>
<li>
<p>Annotation - which annotations support this injection</p>

</li>
<li>
<p>Modules - which WebServer extension modules support this injection</p>

</li>
<li>
<p>Notes - additional details</p>

</li>
</ul>

<div class="block-title"><span>Injectable types.</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 20%;">
<col style="width: 20%;">
<col style="width: 20%;">
<col style="width: 20%;">
<col style="width: 20%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">Type</td>
<td class="">Socket?</td>
<td class="">Annotation</td>
<td class="">Modules</td>
<td class="">Notes</td>
</tr>
<tr>
<td class=""><code>WebServer</code></td>

<td class=""><code>@ServerTest</code></td>

<td class="">Server instance (already started)</td>
</tr>
<tr>
<td class=""><code>URI</code></td>
<td class="">x</td>
<td class=""><code>@ServerTest</code></td>

<td class="">URI pointing to a port of the webserver</td>
</tr>
<tr>
<td class=""><code>SocketHttpClient</code></td>
<td class="">x</td>
<td class=""><code>@ServerTest</code></td>

<td class="">This client allows you to send anything in order to test for bad requests or other issues.</td>
</tr>
<tr>
<td class=""><code>Http1Client</code></td>
<td class="">x</td>
<td class=""><code>@ServerTest</code></td>


</tr>
<tr>
<td class=""><code>DirectClient</code></td>
<td class="">x</td>
<td class=""><code>@RoutingTest</code></td>

<td class="">Implements <code>Http1Client</code> API</td>
</tr>
<tr>
<td class=""><code>WsClient</code></td>
<td class="">x</td>
<td class=""><code>@ServerTest</code></td>
<td class="">websocket</td>

</tr>
<tr>
<td class=""><code>DirectWsClient</code></td>
<td class="">x</td>
<td class=""><code>@RoutingTest</code></td>
<td class="">websocket</td>
<td class="">Implements <code>WsClient</code> API</td>
</tr>
</tbody>
</table>
</div>

<p>Extensions can enhance the features for the module <code>helidon-testing-junit5-webserver</code> to support additional protocols.</p>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>You can create the following test to validate that the server returns the correct response:</p>

<markup
lang="java"
title="Basic Helidon test framework usage."
>@ServerTest <span class="conum" data-value="1" />
class MyServerTest {

    final Http1Client client;

    MyServerTest(Http1Client client) { <span class="conum" data-value="2" />
        this.client = client;
    }

    @SetUpRoute <span class="conum" data-value="3" />
    static void routing(HttpRouting.Builder builder) {
        Main.routing(builder);
    }

    @Test
    void testRootRoute() { <span class="conum" data-value="4" />
        try (Http1ClientResponse response = client
                .get("/greet")
                .request()) { <span class="conum" data-value="5" />
            assertThat(response.status(), is(Status.OK_200)); <span class="conum" data-value="6" />
        }
    }
}</markup>

<ul class="colist">
<li data-value="1">Use <code>@ServerTest</code> to trigger the testing framework.</li>
<li data-value="2">Inject <code>Http1Client</code> for the test.</li>
<li data-value="3">SetUp routing for the test.</li>
<li data-value="4">Regular <code>JUnit</code> test method.</li>
<li data-value="5">Call the <code>client</code> to obtain server response</li>
<li data-value="6">Perform the necessary assertions.</li>
</ul>

<p>To trigger the framework to start and configure the server, annotate the testing class with the <code>@ServerTest</code> annotation.</p>

<p>In this test, the <code>Http1Client</code> client is used, which means that the framework will create, configure, and inject this object as a parameter to the constructor.</p>

<p>To set up routing, a static method annotated with <code>@SetUpRoute</code> is present. The framework uses this method to inject the configured routing to the subject of testing – in the current case, the <code>Quickstart</code> application.</p>

<p>As everything above is performed by the testing framework, regular unit tests can be done. After completing all tests, the testing framework will shut down the server.</p>


<h3 id="_routing_tests">Routing Tests</h3>
<div class="section">
<p>If there is no need to set up and run a server, a <code>DirectClient</code> client can be used. It is a testing client that bypasses HTTP transport and directly invokes the router.</p>

<markup
lang="java"
title="Routing test using <code>@RoutingTest</code> and <code>DirectClient</code>."
>@RoutingTest <span class="conum" data-value="1" />
class MyRoutingTest {

    final Http1Client client;

    MyRoutingTest(DirectClient client) { <span class="conum" data-value="2" />
        this.client = client;
    }

    @SetUpRoute <span class="conum" data-value="3" />
    static void routing(HttpRouting.Builder builder) {
        Main.routing(builder);
    }

    @Test
    void testRootRoute() { <span class="conum" data-value="4" />
        try (Http1ClientResponse response = client
                .get("/greet")
                .request()) { <span class="conum" data-value="5" />
            JsonObject json = response.as(JsonObject.class); <span class="conum" data-value="6" />
            assertThat(json.getString("message"), is("Hello World!"));
        }
    }
}</markup>

<ul class="colist">
<li data-value="1">Use <code>@RoutingTest</code> to trigger the testing framework.</li>
<li data-value="2">Inject <code>DirectClient</code> for the test.</li>
<li data-value="3">SetUp routing for the test.</li>
<li data-value="4">A regular <code>JUnit</code> test method.</li>
<li data-value="5">Call the <code>client</code> to obtain server response.</li>
<li data-value="6">Perform  the necessary assertions.</li>
</ul>

<p>If only routing tests are required, this is a "lighter" way of testing because the framework will not configure and run the full Helidon server. This way, no real ports will be opened. All the communication will be done through <code>DirectClient</code>, which makes the tests very effective.</p>

<p>It is required to annotate the test class with the <code>@RoutingTest</code> annotation to trigger the server to do the configuration. Thus, it will inject the DirectClient client, which can then be used in unit tests.</p>

<p>Routing is configured the same way as in full server testing using the <code>@SetUpRoute</code> annotation.</p>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="_websocket_testing">WebSocket Testing</h3>
<div class="section">
<p>If WebSocket testing is required, there is an additional module for it. It is necessary to include the following Maven dependency to the Project&#8217;s pom file:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.testing.junit5&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-testing-junit5-websocket&lt;/artifactId&gt;
    &lt;scope&gt;test&lt;/scope&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_websocket_testing_example">WebSocket Testing Example</h3>
<div class="section">
<p>The WebSocket Testing extension adds support for routing configuration and injection of WebSocket related artifacts, such as WebSockets and DirectWsClient in Helidon unit tests.</p>

<markup
lang="java"
title="WebSocket sample test."
>@ServerTest
class WsSocketTest {

    static final ServerSideListener WS_LISTENER = new ServerSideListener();
    final WsClient wsClient; <span class="conum" data-value="1" />

    WsSocketTest(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    @SetUpRoute
    static void routing(WsRouting.Builder ws) { <span class="conum" data-value="2" />
        ws.endpoint("/testWs", WS_LISTENER);
    }

    @Test
    void testWsEndpoint() { <span class="conum" data-value="3" />
        ClientSideListener clientListener = new ClientSideListener();
        wsClient.connect("/testWs", clientListener); <span class="conum" data-value="4" />
        assertThat(clientListener.message, is("ws")); <span class="conum" data-value="5" />
    }
}</markup>

<ul class="colist">
<li data-value="1">Declare <code>WsClient</code> and later inject it in the constructor.</li>
<li data-value="2">Using @SetUpRoute, create WebSocket routing and assign a serverside listener.</li>
<li data-value="3">Test the WebSocket endpoint using the regular @Test annotation.</li>
<li data-value="4">Create and assign the clientside listener.</li>
<li data-value="5">Check if the received message is correct.</li>
</ul>

<markup
lang="java"
title="<code>ClientSideListener</code> helper class."
>static class ClientSideListener implements WsListener {
    volatile String message;
    volatile Throwable error;

    @Override
    public void onOpen(WsSession session) { <span class="conum" data-value="1" />
        session.send("hello", true);
    }

    @Override
    public void onMessage(WsSession session, String text, boolean last) { <span class="conum" data-value="2" />
        message = text;
        session.close(WsCloseCodes.NORMAL_CLOSE, "End");
    }

    @Override
    public void onError(WsSession session, Throwable t) { <span class="conum" data-value="3" />
        error = t;
    }
}</markup>

<ul class="colist">
<li data-value="1">Send "Hello" when a connection is opened.</li>
<li data-value="2">Save the message when received and close the connection.</li>
<li data-value="3">React on an error.</li>
</ul>

<p>The WebSocket <code>ClientSideListener</code> is also a helper class that implements <code>WsListener</code> and is very straightforward:</p>

<markup
lang="java"
title="<code>ServerSideListener</code> helper class."
>static class ServerSideListener implements WsListener {
    volatile String message;

    @Override
    public void onMessage(WsSession session, String text, boolean last) { <span class="conum" data-value="1" />
        message = text;
        session.send("ws", true);
    }
}</markup>

<ul class="colist">
<li data-value="1">Send "ws" on a received message.</li>
</ul>

<p>The testing class should be annotated with <code>@RoutingTest</code> only if routing tests are required without real port opening. Instead of <code>WsClient</code>, use <code>DirectWsClient</code>.</p>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://junit.org/junit5/docs/current/user-guide/">JUnit 5 User Guide</a></p>

</li>
</ul>

</div>

</doc-view>
